/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.test.ext.jaxrs.services.car.CarListResource;
import org.restlet.test.ext.jaxrs.services.car.CarResource;
import org.restlet.test.ext.jaxrs.services.car.EngineResource;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;

public class CarTest
extends JaxRsTestCase {
    public static void main(String[] args) throws Exception {
        new CarTest().runServerUntilKeyPressed();
    }

    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(CarListResource.class);
            }
        };
    }

    public void testDelete() throws Exception {
        Response response = this.accessServer(Method.DELETE, CarListResource.class, null, null);
        CarTest.assertTrue((String)("The status should be a client error, but was " + response.getStatus()), (boolean)response.getStatus().isClientError());
        CarTest.assertEquals((Object)Status.CLIENT_ERROR_METHOD_NOT_ALLOWED, (Object)response.getStatus());
    }

    public void testEngine() throws Exception {
        Response response = this.get("4711/engine");
        CarTest.sysOutEntityIfError(response);
        CarTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation entity = response.getEntity();
        CarTest.assertEqualMediaType(MediaType.TEXT_PLAIN, entity.getMediaType());
        CarTest.assertEquals((String)EngineResource.getPlainRepr(4711), (String)entity.getText());
    }

    public void testGetCar() throws Exception {
        String carNumber = "57";
        Response response = this.get("57");
        Representation entity = response.getEntity();
        CarTest.sysOutEntityIfError(response);
        CarTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        CarTest.assertEquals((String)CarResource.createTextRepr("57"), (String)entity.getText());
        CarTest.assertEqualMediaType(MediaType.TEXT_PLAIN, entity.getMediaType());
    }

    public void testGetHtmlText() throws Exception {
        Response response = this.get(MediaType.TEXT_HTML);
        CarTest.assertTrue((String)("The status should be a client error, but was " + response.getStatus()), (boolean)response.getStatus().isClientError());
        CarTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_ACCEPTABLE, (Object)response.getStatus());
    }

    public void testGetOffers() throws Exception {
        Response response = this.get("offers");
        Representation representation = response.getEntity();
        CarTest.sysOutEntityIfError(response);
        CarTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        CarTest.assertEquals((String)"This are test offers", (String)representation.getText());
        MediaType actualMediaType = representation.getMediaType();
        CarTest.assertEqualMediaType(MediaType.TEXT_PLAIN, actualMediaType);
    }

    public void testGetPlainText() throws Exception {
        Response response = this.get(MediaType.TEXT_PLAIN);
        Status status = response.getStatus();
        CarTest.assertTrue((String)("Status should be 2xx, but is " + status), (boolean)status.isSuccess());
        Representation representation = response.getEntity();
        CarTest.assertEquals((String)"[1, 2, 5]", (String)representation.getText());
        CarTest.assertEqualMediaType(MediaType.TEXT_PLAIN, representation.getMediaType());
    }

    public void testOptions() throws Exception {
        Response response = this.options();
        CarTest.assertAllowedMethod(response, Method.GET, Method.POST);
        response = this.options("offers");
        CarTest.assertAllowedMethod(response, Method.GET, Method.POST);
        response = this.options("53");
        CarTest.assertAllowedMethod(response, Method.GET);
    }
}

