/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.test.ext.jaxrs.services.resources.DeterminingMediaTypeTestService;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;

public class DeterminingMediaTypeTest
extends JaxRsTestCase {
    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(DeterminingMediaTypeTestService.class);
            }
        };
    }

    public void testHtmlPlainGif1() {
        Response response = this.get("htmlPlainGif", MediaType.TEXT_ALL);
        DeterminingMediaTypeTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        DeterminingMediaTypeTest.assertEqualMediaType(MediaType.TEXT_HTML, response);
    }

    public void testHtmlPlainGif2() {
        Response response = this.get("htmlPlainGif", MediaType.ALL);
        DeterminingMediaTypeTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        DeterminingMediaTypeTest.assertEqualMediaType(MediaType.TEXT_HTML, response);
    }

    public void testHtmlPlainGif3() {
        Response response = this.get("htmlPlainGif", MediaType.IMAGE_GIF);
        DeterminingMediaTypeTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        DeterminingMediaTypeTest.assertEqualMediaType(MediaType.IMAGE_GIF, response);
    }

    public void testHtmlPlainGif4() {
        Response response = this.get("htmlPlainGif", MediaType.TEXT_PLAIN);
        DeterminingMediaTypeTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        DeterminingMediaTypeTest.assertEqualMediaType(MediaType.TEXT_PLAIN, response);
    }

    public void testTextStar1() {
        Response response = this.get("textStar", MediaType.TEXT_ALL);
        DeterminingMediaTypeTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_ACCEPTABLE, (Object)response.getStatus());
        response = this.get("textStar", MediaType.ALL);
        DeterminingMediaTypeTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_ACCEPTABLE, (Object)response.getStatus());
        response = this.get("textStar", MediaType.IMAGE_GIF);
        DeterminingMediaTypeTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_ACCEPTABLE, (Object)response.getStatus());
    }

    public void testTextStar2() {
        Response response = this.get("textStar", MediaType.TEXT_HTML);
        DeterminingMediaTypeTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        DeterminingMediaTypeTest.assertEqualMediaType(MediaType.TEXT_HTML, response);
    }

    public void testTextStar3() {
        Response response = this.get("textStar", MediaType.TEXT_PLAIN);
        DeterminingMediaTypeTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        DeterminingMediaTypeTest.assertEqualMediaType(MediaType.TEXT_PLAIN, response);
    }
}

