/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.test.ext.jaxrs.services.providers.IllegalArgExcMapper;
import org.restlet.test.ext.jaxrs.services.resources.ExcMapperTestResource;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;

public class ExcMapperTest
extends JaxRsTestCase {
    private void check(MediaType accMediaType, MediaType expMediaType) {
        Response response = this.get(accMediaType);
        ExcMapperTest.sysOutEntityIfError(response);
        ExcMapperTest.assertEquals((int)599, (int)response.getStatus().getCode());
        ExcMapperTest.assertEqualMediaType(expMediaType, response);
    }

    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(ExcMapperTestResource.class);
            }

            public Set<Object> getSingletons() {
                return Collections.singleton(new IllegalArgExcMapper());
            }
        };
    }

    public void testHtml() {
        this.check(MediaType.TEXT_HTML, MediaType.TEXT_HTML);
    }

    public void testImage() {
        this.check(MediaType.IMAGE_BMP, MediaType.TEXT_PLAIN);
    }

    public void testPlain() {
        this.check(MediaType.TEXT_PLAIN, MediaType.TEXT_PLAIN);
    }

    public void testXml() {
        this.check(MediaType.TEXT_XML, MediaType.TEXT_PLAIN);
    }
}

