/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.test.ext.jaxrs.services.resources.FormTestResource;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;

public class FormTest
extends JaxRsTestCase {
    private void check(String subPath, boolean cPerhapsDouble) throws IOException {
        this.check1(subPath);
        this.check2(subPath);
        this.check3(subPath, cPerhapsDouble);
    }

    private Representation check1(String subPath) throws IOException {
        Form form = new Form();
        form.add("a", "b");
        Representation webRepresentation = form.getWebRepresentation();
        Response response = this.post(subPath, webRepresentation);
        FormTest.sysOutEntityIfError(response);
        FormTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        FormTest.assertEquals((String)"a -> b\n", (String)response.getEntity().getText());
        return webRepresentation;
    }

    private void check2(String subPath) throws IOException {
        Form form = new Form();
        form.add("a", "b");
        form.add("c", "d");
        Response response = this.post(subPath, form.getWebRepresentation());
        FormTest.sysOutEntityIfError(response);
        FormTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        FormTest.assertEquals((String)"a -> b\nc -> d\n", (String)response.getEntity().getText());
    }

    private void check3(String subPath, boolean cDouble) throws IOException {
        Form form = new Form();
        form.add("a", "b");
        form.add("c", "d");
        form.add("c", "d2");
        Response response = this.post(subPath, form.getWebRepresentation());
        FormTest.sysOutEntityIfError(response);
        FormTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        String expectedEntity = "a -> b\nc -> d\n";
        if (cDouble) {
            expectedEntity = expectedEntity + "c -> d2\n";
        }
        FormTest.assertEquals((String)expectedEntity, (String)response.getEntity().getText());
    }

    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(FormTestResource.class);
            }

            public Set<Object> getSingletons() {
                return Collections.emptySet();
            }
        };
    }

    public void testCheckUnmodifiable() {
        Form form = new Form();
        form.add("a", "b");
        form.add("a", "c");
        Response response = this.post("checkUnmodifiable", form.getWebRepresentation());
        FormTest.sysOutEntityIfError(response);
        FormTest.assertTrue((String)("The List annotated with @FormParam must not be modifiable. Status is " + response.getStatus()), (boolean)response.getStatus().isSuccess());
    }

    public void testFormAndParam() throws IOException {
        this.check("formAndParam", true);
    }

    public void testFormOnly() throws IOException {
        this.check("formOnly", true);
    }

    public void testParamAndForm() throws IOException {
        this.check("paramAndForm", true);
    }

    public void testParamOnly() throws IOException {
        this.check("paramOnly", false);
    }
}

