/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.test.ext.jaxrs.services.resources.HeadOptionsTestService;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;

public class HeadOptionsTest
extends JaxRsTestCase {
    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(HeadOptionsTestService.class);
            }
        };
    }

    public void testHead1() throws Exception {
        Response responseGett = this.get("headTest1", MediaType.TEXT_HTML);
        Response responseHead = this.head("headTest1", MediaType.TEXT_HTML);
        if (responseGett.getStatus().isError()) {
            System.out.println(responseGett.getEntity().getText());
        }
        HeadOptionsTest.assertEquals((Object)Status.SUCCESS_OK, (Object)responseGett.getStatus());
        if (responseHead.getStatus().isError()) {
            System.out.println(responseHead.getEntity().getText());
        }
        HeadOptionsTest.assertEquals((Object)Status.SUCCESS_OK, (Object)responseHead.getStatus());
        Representation entityGett = responseGett.getEntity();
        Representation entityHead = responseHead.getEntity();
        HeadOptionsTest.assertNotNull((Object)entityGett);
        HeadOptionsTest.assertNotNull((String)"Must not be null to read the entity headers", (Object)entityHead);
        HeadOptionsTest.assertEqualMediaType(MediaType.TEXT_HTML, entityGett.getMediaType());
        HeadOptionsTest.assertEqualMediaType(MediaType.TEXT_HTML, entityHead.getMediaType());
        HeadOptionsTest.assertEquals((String)"4711", (String)entityGett.getText());
        HeadOptionsTest.assertEquals((String)"The entity text of the head request must be null", null, (String)entityHead.getText());
    }

    public void testHead2() throws Exception {
        Response responseGett = this.get("headTest2", MediaType.TEXT_HTML);
        Response responseHead = this.head("headTest2", MediaType.TEXT_HTML);
        if (responseGett.getStatus().isError()) {
            System.out.println(responseGett.getEntity().getText());
        }
        HeadOptionsTest.assertEquals((Object)Status.SUCCESS_OK, (Object)responseGett.getStatus());
        if (responseHead.getStatus().isError()) {
            System.out.println(responseHead.getEntity().getText());
        }
        HeadOptionsTest.assertEquals((Object)Status.SUCCESS_OK, (Object)responseHead.getStatus());
        Representation entityGett = responseGett.getEntity();
        Representation entityHead = responseHead.getEntity();
        HeadOptionsTest.assertNotNull((Object)entityGett);
        HeadOptionsTest.assertNotNull((String)"Must not be null to read the entity headers", (Object)entityHead);
        HeadOptionsTest.assertEqualMediaType(MediaType.TEXT_HTML, entityGett.getMediaType());
        HeadOptionsTest.assertEqualMediaType(MediaType.TEXT_HTML, entityHead.getMediaType());
        HeadOptionsTest.assertEquals((String)"4711", (String)entityGett.getText());
        HeadOptionsTest.assertEquals((String)"The entity text of the head request must be null", null, (String)entityHead.getText());
    }

    public void testHead2plain() throws Exception {
        Response responseGett = this.get("headTest2", MediaType.TEXT_PLAIN);
        Response responseHead = this.head("headTest2", MediaType.TEXT_PLAIN);
        if (responseGett.getStatus().isError()) {
            System.out.println(responseGett.getEntity().getText());
        }
        HeadOptionsTest.assertEquals((Object)Status.SUCCESS_OK, (Object)responseGett.getStatus());
        if (responseHead.getStatus().isError()) {
            System.out.println(responseHead.getEntity().getText());
        }
        HeadOptionsTest.assertEquals((Object)Status.SUCCESS_OK, (Object)responseHead.getStatus());
        Representation entityGett = responseGett.getEntity();
        Representation entityHead = responseHead.getEntity();
        HeadOptionsTest.assertNotNull((Object)entityGett);
        HeadOptionsTest.assertNotNull((String)"Must not be null to read the entity headers", (Object)entityHead);
        HeadOptionsTest.assertEqualMediaType(MediaType.TEXT_PLAIN, entityGett.getMediaType());
        HeadOptionsTest.assertEqualMediaType(MediaType.TEXT_PLAIN, entityHead.getMediaType());
        HeadOptionsTest.assertEquals((String)"4711", (String)entityGett.getText());
        HeadOptionsTest.assertEquals((String)"The entity text of the head request must be null", null, (String)entityHead.getText());
    }

    public void testOptions() throws Exception {
        Response response = this.options();
        HeadOptionsTest.assertAllowedMethod(response, Method.GET);
        response = this.options("headTest1");
        HeadOptionsTest.assertAllowedMethod(response, Method.GET, Method.HEAD, Method.POST);
        response = this.options("headTest2");
        HeadOptionsTest.assertAllowedMethod(response, Method.GET, Method.HEAD);
        response = this.options("xyz");
        HeadOptionsTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response.getStatus());
    }
}

