/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.test.ext.jaxrs.services.resources.InheritAnnotationTestService1;
import org.restlet.test.ext.jaxrs.services.resources.InheritAnnotationTestService2;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;

public class InheritAnnotationTest
extends JaxRsTestCase {
    private static final Class<InheritAnnotationTestService1> SERVICE_1 = InheritAnnotationTestService1.class;
    private static final Class<InheritAnnotationTestService2> SERVICE_2 = InheritAnnotationTestService2.class;

    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                HashSet rrcs = new HashSet(2);
                rrcs.add(SERVICE_1);
                rrcs.add(SERVICE_2);
                return rrcs;
            }
        };
    }

    public void test1() throws Exception {
        Reference reference = this.createReference(SERVICE_1, "getText");
        Response response = this.accessServer(Method.GET, reference);
        InheritAnnotationTest.sysOutEntityIfError(response);
        InheritAnnotationTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        InheritAnnotationTest.assertEqualMediaType(MediaType.TEXT_PLAIN, response);
        String entityText = response.getEntity().getText();
        InheritAnnotationTest.assertEquals((String)"getTextWithoutSubResource", (String)entityText);
    }

    public void test2a() throws Exception {
        Reference reference = this.createReference(SERVICE_2, "getText");
        Response response = this.accessServer(Method.GET, reference);
        InheritAnnotationTest.sysOutEntityIfError(response);
        InheritAnnotationTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        InheritAnnotationTest.assertEqualMediaType(MediaType.TEXT_PLAIN, response);
        String entityText = response.getEntity().getText();
        InheritAnnotationTest.assertEquals((String)"fromGetTextResource", (String)entityText);
    }

    public void test2b() throws Exception {
        Reference reference = this.createReference(SERVICE_2, "getSubClassText");
        Response response = this.accessServer(Method.GET, reference);
        InheritAnnotationTest.sysOutEntityIfError(response);
        InheritAnnotationTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        InheritAnnotationTest.assertEqualMediaType(MediaType.TEXT_PLAIN, response);
        String entityText = response.getEntity().getText();
        InheritAnnotationTest.assertEquals((String)"fromGetTextExtResource", (String)entityText);
    }

    public void x_test2c() throws Exception {
        Reference reference = this.createReference(SERVICE_2, "getSubClassText/sub");
        Response response = this.accessServer(Method.GET, reference);
        InheritAnnotationTest.sysOutEntityIfError(response);
        InheritAnnotationTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        InheritAnnotationTest.assertEqualMediaType(MediaType.TEXT_PLAIN, response);
        String entityText = response.getEntity().getText();
        InheritAnnotationTest.assertEquals((String)"fromGetTextExt2Resource", (String)entityText);
    }
}

