/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.test.ext.jaxrs.services.resources.Issue594Resources;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;

public class Issue594Test
extends JaxRsTestCase {
    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(Issue594Resources.class);
            }
        };
    }

    public void testGetRoot() throws Exception {
        Response response = this.get();
        Issue594Test.sysOutEntityIfError(response);
        Issue594Test.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation entity = response.getEntity();
        Issue594Test.assertEqualMediaType(MediaType.TEXT_PLAIN, entity.getMediaType());
        Issue594Test.assertEquals((String)"root", (String)entity.getText());
    }

    public void testGetRepository() throws Exception {
        Response response = this.get("PRJ");
        Representation entity = response.getEntity();
        Issue594Test.sysOutEntityIfError(response);
        Issue594Test.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Issue594Test.assertEqualMediaType(MediaType.TEXT_PLAIN, entity.getMediaType());
        Issue594Test.assertEquals((String)"project=PRJ", (String)entity.getText());
    }

    public void testGetProject() throws Exception {
        Response response = this.get("PRJ/REPO");
        Representation entity = response.getEntity();
        Issue594Test.sysOutEntityIfError(response);
        Issue594Test.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Issue594Test.assertEqualMediaType(MediaType.TEXT_PLAIN, entity.getMediaType());
        Issue594Test.assertEquals((String)"project=PRJ\nrepository=REPO", (String)entity.getText());
    }

    public void testGetSchemaDir() throws Exception {
        Response response = this.get("PRJ/REPO/schema");
        Representation entity = response.getEntity();
        Issue594Test.sysOutEntityIfError(response);
        Issue594Test.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Issue594Test.assertEqualMediaType(MediaType.TEXT_PLAIN, entity.getMediaType());
        Issue594Test.assertEquals((String)"project=PRJ\nrepository=REPO\nschema", (String)entity.getText());
    }

    public void testGetSchema() throws Exception {
        Response response = this.get("PRJ/REPO/schema/SCM");
        Representation entity = response.getEntity();
        Issue594Test.sysOutEntityIfError(response);
        Issue594Test.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Issue594Test.assertEqualMediaType(MediaType.TEXT_PLAIN, entity.getMediaType());
        Issue594Test.assertEquals((String)"project=PRJ\nrepository=REPO\nschema\nschema=SCM", (String)entity.getText());
    }

    public void testFooBarSimple() throws Exception {
        Response response = this.get("/foo/bar/schema/simple");
        Representation entity = response.getEntity();
        Issue594Test.sysOutEntityIfError(response);
        Issue594Test.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Issue594Test.assertEqualMediaType(MediaType.TEXT_PLAIN, entity.getMediaType());
        Issue594Test.assertEquals((String)"project=foo\nrepository=bar\nschema\nschema=simple", (String)entity.getText());
    }
}

