/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.test.ext.jaxrs.services.resources.MatchedTestService;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;

public class MatchedTest
extends JaxRsTestCase {
    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(MatchedTestService.class);
            }
        };
    }

    public void testGet() throws Exception {
        Response response = this.get();
        MatchedTest.sysOutEntityIfError(response);
        MatchedTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatchedTest.assertEquals((String)"1\n1", (String)response.getEntity().getText());
    }

    public void testGetSub() throws Exception {
        Response response = this.get("sub");
        MatchedTest.sysOutEntityIfError(response);
        MatchedTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatchedTest.assertEquals((String)"2\n2", (String)response.getEntity().getText());
    }

    public void testGetSubSameSub() throws Exception {
        Response response = this.get("sub/sameSub");
        MatchedTest.sysOutEntityIfError(response);
        MatchedTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatchedTest.assertEquals((String)"3\n3", (String)response.getEntity().getText());
    }

    public void testGetSubSub() throws Exception {
        Response response = this.get("sub/sub");
        MatchedTest.sysOutEntityIfError(response);
        MatchedTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatchedTest.assertEquals((String)"3\n3", (String)response.getEntity().getText());
    }

    public void testResourceClassNames() throws Exception {
        Response response = this.get("resourceClassNames");
        MatchedTest.sysOutEntityIfError(response);
        MatchedTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatchedTest.assertEquals((String)"2\norg.restlet.test.ext.jaxrs.services.resources.MatchedTestService\norg.restlet.test.ext.jaxrs.services.resources.MatchedTestService", (String)response.getEntity().getText());
    }

    public void testSameSubSubUri() throws Exception {
        Response response = this.get("sameSub/sub/uris");
        MatchedTest.sysOutEntityIfError(response);
        MatchedTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatchedTest.assertEquals((String)"4\n/matchedTest/sameSub/sub/uris\n/matchedTest/sameSub/sub\n/matchedTest/sameSub\n/matchedTest", (String)response.getEntity().getText());
    }

    public void testUri() throws Exception {
        Response response = this.get("uris");
        MatchedTest.sysOutEntityIfError(response);
        MatchedTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MatchedTest.assertEquals((String)"2\n/matchedTest/uris\n/matchedTest", (String)response.getEntity().getText());
    }

    public void testUriInfos() throws Exception {
        Response response404 = this.get("uriInfo/abc");
        MatchedTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response404.getStatus());
        Response response = this.get("uriInfo/matchedURIs");
        MatchedTest.sysOutEntityIfError(response);
        MatchedTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        String entity = response.getEntity().getText();
        String expected = "[]\n[/matchedTest/uriInfo/matchedURIs, /matchedTest]";
        System.out.println("expected:\n[]\n[/matchedTest/uriInfo/matchedURIs, /matchedTest]\ngot:\n" + entity);
        MatchedTest.assertEquals((String)"[]\n[/matchedTest/uriInfo/matchedURIs, /matchedTest]", (String)entity);
    }

    public void testUriInfosSub() throws Exception {
        Response response404 = this.get("sub/uriInfo/abc");
        MatchedTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response404.getStatus());
        Response response = this.get("sub/uriInfo/matchedURIs");
        MatchedTest.sysOutEntityIfError(response);
        MatchedTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        String entity = response.getEntity().getText();
        String expected = "[]\n[/matchedTest/sub/uriInfo/matchedURIs, /matchedTest/sub, /matchedTest]";
        System.out.println("expected:\n[]\n[/matchedTest/sub/uriInfo/matchedURIs, /matchedTest/sub, /matchedTest]\ngot:\n" + entity);
        MatchedTest.assertEquals((String)"[]\n[/matchedTest/sub/uriInfo/matchedURIs, /matchedTest/sub, /matchedTest]", (String)entity);
    }
}

