/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.test.ext.jaxrs.services.providers.AppCrazyPersonProvider;
import org.restlet.test.ext.jaxrs.services.providers.TextCrazyPersonProvider;
import org.restlet.test.ext.jaxrs.services.resources.MessageBodyWriterTestResource;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;
import org.restlet.test.ext.jaxrs.util.TestUtils;

public class MessageBodyWritersTest
extends JaxRsTestCase {
    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(MessageBodyWriterTestResource.class);
            }

            public Set<Object> getSingletons() {
                return TestUtils.createSet(new AppCrazyPersonProvider(), new TextCrazyPersonProvider());
            }
        };
    }

    public void test1() throws IOException {
        Response response = this.get();
        Representation entity = response.getEntity();
        MessageBodyWritersTest.sysOutEntityIfError(response);
        MessageBodyWritersTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MessageBodyWritersTest.assertEqualMediaType(new MediaType("application/crazy-person"), entity);
        MessageBodyWritersTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><firstname>Angela</firstname><lastname>Merkel</lastname></person>Angela Merkel is crazy.\nHeader value for name h1 is h1v", (String)entity.getText());
    }
}

