/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.test.ext.jaxrs.services.providers.TextCrazyPersonProvider;
import org.restlet.test.ext.jaxrs.services.resources.OwnProviderTestService;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;
import org.restlet.test.ext.jaxrs.util.TestUtils;

public class OwnProviderTest
extends JaxRsTestCase {
    @Override
    protected Application getApplication() {
        Application appConfig = new Application(){

            public Set<Object> getSingletons() {
                return TestUtils.createSet(new TextCrazyPersonProvider());
            }

            public Set<Class<?>> getClasses() {
                return Collections.singleton(OwnProviderTestService.class);
            }
        };
        return appConfig;
    }

    public void test1() throws Exception {
        Response response = this.get();
        OwnProviderTest.sysOutEntityIfError(response);
        OwnProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        OwnProviderTest.assertEqualMediaType(new MediaType("text/crazy-person"), response);
        String actualEntity = response.getEntity().getText();
        String expectedEntity = "abc def is crazy.\nHeader value for name h1 is h1v";
        OwnProviderTest.assertEquals((String)"abc def is crazy.\nHeader value for name h1 is h1v", (String)actualEntity);
    }
}

