/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.test.ext.jaxrs.services.resources.PathParamTestResource3;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;

public class PathParamTest3
extends JaxRsTestCase {
    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(PathParamTestResource3.class);
            }
        };
    }

    public void test() throws Exception {
        this.doTest("AAAABBBB", "eeeee", "AAAABBBB", "eeeee");
        this.doTest("AAA%2FBB", "eeeee", "AAA/BB", "eeeee");
        this.doTest("AAA%2FBB", "e%2Fe", "AAA/BB", "e/e");
        this.doTest("AAAABBBB", "e%2Fe", "AAAABBBB", "e/e");
    }

    private void doTest(String doctypeEncoded, String entryidEncoded, String doctypeDecoded, String entryidDecoded) throws IOException {
        Reference reference = this.createBaseRef();
        reference = new Reference(reference + "/supplemental/" + doctypeEncoded + "/" + entryidEncoded);
        Response response = this.get(reference);
        PathParamTest3.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        PathParamTest3.assertEquals((String)(doctypeDecoded + "\n" + entryidDecoded + "\n"), (String)response.getEntity().getText());
    }
}

