/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.jaxb.JaxbRepresentation;
import org.restlet.representation.Representation;
import org.restlet.test.ext.jaxrs.services.others.Person;
import org.restlet.test.ext.jaxrs.services.others.PersonList;
import org.restlet.test.ext.jaxrs.services.resources.PersonResource;
import org.restlet.test.ext.jaxrs.services.resources.PersonsResource;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;
import org.restlet.test.ext.jaxrs.util.OrderedReadonlySet;

public class PersonsTest
extends JaxRsTestCase {
    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return new OrderedReadonlySet(PersonsResource.class, PersonResource.class);
            }
        };
    }

    public void testCreate() throws Exception {
        if (PersonsTest.usesTcp()) {
            return;
        }
        Person newPerson = new Person("Kurt", "Beck");
        Response response1 = this.post((Representation)new JaxbRepresentation((Object)newPerson));
        PersonsTest.sysOutEntityIfError(response1);
        PersonsTest.assertEquals((Object)Status.SUCCESS_CREATED, (Object)response1.getStatus());
        Reference newLocation = response1.getLocationRef();
        Response response2 = this.get(newLocation, MediaType.APPLICATION_JAVASCRIPT, MediaType.TEXT_XML);
        PersonsTest.sysOutEntityIfError(response2);
        PersonsTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response2.getStatus());
        JaxbRepresentation repr = new JaxbRepresentation(response2.getEntity(), Person.class);
        Person person = (Person)repr.getObject();
        PersonsTest.assertTrue((boolean)person.getFirstname().startsWith("firstname"));
        PersonsTest.assertEquals((String)"lastname", (String)person.getLastname());
        Response response3 = this.get(newLocation, MediaType.ALL);
        PersonsTest.sysOutEntityIfError(response3);
        PersonsTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response3.getStatus());
        JaxbRepresentation repr3 = new JaxbRepresentation(response3.getEntity(), Person.class);
        Person person3 = (Person)repr3.getObject();
        PersonsTest.assertTrue((boolean)person3.getFirstname().startsWith("firstname"));
        PersonsTest.assertEquals((String)"lastname", (String)person3.getLastname());
    }

    public void testGetList() throws Exception {
        Response response = this.get();
        PersonsTest.sysOutEntityIfError(response);
        JaxbRepresentation personListRepr = new JaxbRepresentation(response.getEntity(), PersonList.class);
        List<Person> persons = ((PersonList)personListRepr.getObject()).getPersons();
        PersonsTest.assertEquals((int)3, (int)persons.size());
        PersonsTest.assertEquals((String)"Angela", (String)persons.get(0).getFirstname());
        PersonsTest.assertEquals((String)"Olmert", (String)persons.get(1).getLastname());
        PersonsTest.assertEquals((String)"George U.", (String)persons.get(2).getFirstname());
    }
}

