/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.ContextResolver;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.jaxrs.internal.provider.JaxbElementProvider;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.test.ext.jaxrs.services.others.Person;
import org.restlet.test.ext.jaxrs.services.resources.ProviderTestService;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProviderTest
extends JaxRsTestCase {
    public static final boolean LATER = true;

    private static Form createForm() {
        Form form = new Form();
        form.add("firstname", "Angela");
        form.add("lastname", "Merkel");
        return form;
    }

    private void getAndCheckJaxb(String subPath) throws Exception {
        Response response = this.get(subPath);
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        DomRepresentation entity = new DomRepresentation(response.getEntity());
        Node xml = entity.getDocument().getFirstChild();
        System.out.println(subPath + ": " + entity.getText());
        ProviderTest.assertEquals((String)"person", (String)xml.getNodeName());
        NodeList nodeList = xml.getChildNodes();
        Node node = nodeList.item(0);
        ProviderTest.assertEquals((String)"firstname", (String)node.getNodeName());
        ProviderTest.assertEquals((String)"Angela", (String)node.getFirstChild().getNodeValue());
        node = nodeList.item(1);
        ProviderTest.assertEquals((String)"lastname", (String)node.getNodeName());
        ProviderTest.assertEquals((String)"Merkel", (String)node.getFirstChild().getNodeValue());
        ProviderTest.assertEquals((int)2, (int)nodeList.getLength());
    }

    private Response getAndExpectAlphabet(String subPath) throws IOException {
        Response response = this.get(subPath);
        ProviderTest.sysOutEntityIfError(response);
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation entity = response.getEntity();
        ProviderTest.assertEquals((String)"ABCDEFGHIJKLMNOPQRSTUVWXYZ", (String)entity.getText());
        return response;
    }

    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(ProviderTestService.class);
            }
        };
    }

    private void postAndCheckXml(String subPath) throws Exception {
        DomRepresentation send = new DomRepresentation((Representation)new StringRepresentation((CharSequence)"<person><firstname>Helmut</firstname><lastname>Kohl</lastname></person>", MediaType.TEXT_XML));
        Response response = this.post(subPath, (Representation)send);
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation respEntity = response.getEntity();
        ProviderTest.assertEquals((String)"Helmut Kohl", (String)respEntity.getText());
    }

    private void postAndExceptGiven(String subPath, String postEntity, MediaType postMediaType, MediaType responseMediaType) throws IOException {
        StringRepresentation entity = new StringRepresentation((CharSequence)postEntity, postMediaType);
        Response response = this.post(subPath, (Representation)entity);
        ProviderTest.sysOutEntityIfError(response);
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        entity = response.getEntity();
        ProviderTest.assertEquals((String)postEntity, (String)entity.getText());
        if (responseMediaType != null) {
            ProviderTest.assertEqualMediaType(responseMediaType, (Representation)entity);
        }
    }

    public void testBufferedReaderGet() throws Exception {
        this.getAndExpectAlphabet("BufferedReader");
    }

    public void testBufferedReaderPost() throws Exception {
        StringRepresentation entity = new StringRepresentation((CharSequence)"big test", MediaType.APPLICATION_OCTET_STREAM);
        Response response = this.post("BufferedReader", (Representation)entity);
        ProviderTest.sysOutEntityIfError(response);
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        entity = response.getEntity();
        ProviderTest.assertEquals((String)"big test", (String)entity.getText());
    }

    public void testByteArrayGet() throws Exception {
        this.getAndExpectAlphabet("byteArray");
    }

    public void testByteArrayPost() throws Exception {
        StringRepresentation entity = new StringRepresentation((CharSequence)"big test", MediaType.APPLICATION_OCTET_STREAM);
        Response response = this.post("byteArray", (Representation)entity);
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        ProviderTest.assertEquals((String)"big test", (String)response.getEntity().getText());
    }

    public void testCharSequenceGet() throws Exception {
        Response response = this.get("CharSequence");
        ProviderTest.sysOutEntityIfError(response);
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation entity = response.getEntity();
        ProviderTest.assertEquals((String)ProviderTestService.createCS(), (String)entity.getText());
    }

    public void testCharSequencePost() throws Exception {
        this.postAndExceptGiven("CharSequence", "a character sequence", MediaType.TEXT_PLAIN, MediaType.TEXT_PLAIN);
    }

    public void testFileGet() throws Exception {
        this.getAndExpectAlphabet("file");
    }

    public void testFilePost() throws Exception {
        Response response = this.post("file", (Representation)new StringRepresentation((CharSequence)"big test", MediaType.APPLICATION_OCTET_STREAM));
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        ProviderTest.assertEquals((String)"big test", (String)response.getEntity().getText());
    }

    public void testFormGet() throws Exception {
        Response response = this.get("form");
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation entity = response.getEntity();
        ProviderTest.assertEquals((String)"firstname=Angela&lastname=Merkel", (String)entity.getText());
    }

    public void testFormPost() throws Exception {
        Response response = this.post("form", ProviderTest.createForm().getWebRepresentation());
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        String respEntity = response.getEntity().getText();
        ProviderTest.assertEquals((String)"[(firstname,Angela), (lastname,Merkel)]", (String)respEntity);
    }

    public void testInputStreamGet() throws Exception {
        this.getAndExpectAlphabet("InputStream");
    }

    public void testInputStreamPost() throws Exception {
        StringRepresentation entity = new StringRepresentation((CharSequence)"big test", MediaType.APPLICATION_OCTET_STREAM);
        Response response = this.post("InputStream", (Representation)entity);
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        entity = response.getEntity();
        ProviderTest.assertEquals((String)"big test", (String)entity.getText());
    }

    public void testJaxbElementGet() throws Exception {
        this.getAndCheckJaxb("jaxbElement");
    }

    public void testJaxbElementPost() throws Exception {
    }

    public void testJaxbElementPostRootElement() throws Exception {
    }

    public static void main(String[] args) throws Exception {
        Person person = new Person("vn", "nn");
        JaxbElementProvider jaxbElementProvider = new JaxbElementProvider();
        jaxbElementProvider.contextResolver = new ContextResolver<JAXBContext>(){

            public JAXBContext getContext(Class<?> type) {
                return null;
            }
        };
        JAXBElement jaxbElement = new JAXBElement(new QName("xyz"), Person.class, (Object)person);
        jaxbElementProvider.writeTo(jaxbElement, Person.class, Person.class, null, null, null, (OutputStream)System.out);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><firstname>vn</firstname><lastname>nn</lastname></person>";
        ParameterizedType type = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{Person.class};
            }

            @Override
            public Type getOwnerType() {
                throw new UnsupportedOperationException("not implemented for this test");
            }

            @Override
            public Type getRawType() {
                throw new UnsupportedOperationException("not implemented for this test");
            }
        };
        JAXBElement je = jaxbElementProvider.readFrom(JAXBElement.class, (Type)type, null, null, null, (InputStream)new ByteArrayInputStream(xml.getBytes()));
        System.out.println();
    }

    public void testJaxbGet() throws Exception {
        this.getAndCheckJaxb("jaxb");
    }

    public void testJaxbPost() throws Exception {
        if (ProviderTest.usesTcp()) {
            return;
        }
        this.postAndCheckXml("jaxb");
    }

    public void testMultivaluedMapGet() throws Exception {
        Response response = this.get("MultivaluedMap");
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation entity = response.getEntity();
        ProviderTest.assertEquals((String)"lastname=Merkel&firstname=Angela", (String)entity.getText());
    }

    public void testMultivaluedMapPost() throws Exception {
        Response response = this.post("MultivaluedMap", ProviderTest.createForm().getWebRepresentation());
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        MediaType respMediaType = response.getEntity().getMediaType();
        ProviderTest.assertEqualMediaType(MediaType.TEXT_PLAIN, respMediaType);
        String respEntity = response.getEntity().getText();
        ProviderTest.assertEquals((String)"[(lastname,Merkel), (firstname,Angela)]", (String)respEntity);
    }

    public void testReaderGet() throws Exception {
        this.getAndExpectAlphabet("Reader");
    }

    public void testReaderPost() throws Exception {
        this.postAndExceptGiven("Reader", "big test", MediaType.APPLICATION_OCTET_STREAM, null);
    }

    public void testStringBuilderGet() throws Exception {
        this.getAndExpectAlphabet("StringBuilder");
    }

    public void testStringGet() throws Exception {
        this.getAndExpectAlphabet("String");
        Response response = this.get("String2");
        ProviderTest.sysOutEntityIfError(response);
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation entity = response.getEntity();
        ProviderTest.assertEquals((String)"Rom\u00e4n", (String)entity.getText());
    }

    public void testStringPost() throws Exception {
        this.postAndExceptGiven("String", "another String", MediaType.TEXT_PLAIN, MediaType.TEXT_PLAIN);
    }

    public void testSubStringGet() throws Exception {
        Response response = this.get("String/substring;start=5;end=9");
        ProviderTest.sysOutEntityIfError(response);
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        ProviderTest.assertEquals((String)"FGHI", (String)response.getEntity().getText());
    }

    public void testXmlTransformGet() throws Exception {
        Response response = this.get("source");
        ProviderTest.sysOutEntityIfError(response);
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        String entity = response.getEntity().getText();
        ProviderTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><abc/>", (String)entity);
    }

    public void testXmlTransformPost() throws Exception {
        Response response = this.post("source", (Representation)new StringRepresentation((CharSequence)"abcdefg", MediaType.TEXT_XML));
        ProviderTest.sysOutEntityIfError(response);
        ProviderTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        ProviderTest.assertEquals((String)"abcdefg", (String)response.getEntity().getText());
    }
}

