/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.test.ext.jaxrs.services.resources.QueryParamTestService;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;

public class QueryParamTest
extends JaxRsTestCase {
    public void checkBothGiven(String subPath) throws IOException {
        Response response = this.get(subPath + "?firstname=Angela&lastname=Merkel");
        QueryParamTest.sysOutEntityIfError(response);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        QueryParamTest.assertEquals((String)"Angela Merkel", (String)response.getEntity().getText());
        response = this.get(subPath + "?lastname=Merkel&firstname=Angela");
        QueryParamTest.sysOutEntityIfError(response);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        QueryParamTest.assertEquals((String)"Angela Merkel", (String)response.getEntity().getText());
    }

    private void checkMult(String relPath, String res0, String res1, String res2) throws IOException {
        Response response = this.get(relPath);
        QueryParamTest.sysOutEntityIfError(response);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        QueryParamTest.assertEquals((String)res0, (String)response.getEntity().getText());
        response = this.get(relPath + "?qp=1");
        QueryParamTest.sysOutEntityIfError(response);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        QueryParamTest.assertEquals((String)res1, (String)response.getEntity().getText());
        response = this.get(relPath + "?qp=1&qp=2");
        QueryParamTest.sysOutEntityIfError(response);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        QueryParamTest.assertEquals((String)res2, (String)response.getEntity().getText());
    }

    public void checkOneGiven(String subPath) throws IOException {
        Response response = this.get(subPath + "?firstname=Goofy");
        QueryParamTest.sysOutEntityIfError(response);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        QueryParamTest.assertEquals((String)"Goofy null", (String)response.getEntity().getText());
        response = this.get(subPath + "?lastname=Goofy");
        QueryParamTest.sysOutEntityIfError(response);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        QueryParamTest.assertEquals((String)"null Goofy", (String)response.getEntity().getText());
    }

    @Override
    protected Application getApplication() {
        Application appConfig = new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(QueryParamTestService.class);
            }
        };
        return appConfig;
    }

    public void testA() throws IOException {
        this.checkBothGiven("a");
        this.checkOneGiven("a");
    }

    public void testCheckUnmodifiable() {
        Response response = this.get("checkUnmodifiable");
        QueryParamTest.assertTrue((String)"The List annotated with @QueryParam must not be modifiable", (boolean)response.getStatus().isSuccess());
    }

    public void testDecoded() throws IOException {
        Response response = this.get("qpDecoded?firstname=George%20U.&lastname=Bush");
        QueryParamTest.sysOutEntityIfError(response);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        QueryParamTest.assertEquals((String)"George U. Bush", (String)response.getEntity().getText());
    }

    public void testEncodedA() throws IOException {
        Response response = this.get("encodedA?firstname=George%20U.&lastname=Bush");
        QueryParamTest.sysOutEntityIfError(response);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        QueryParamTest.assertEquals((String)"George%20U. Bush", (String)response.getEntity().getText());
    }

    public void testFieldDecoded() throws Exception {
        Response response1 = this.get("decoded?decoded=abc");
        QueryParamTest.sysOutEntityIfError(response1);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response1.getStatus());
        QueryParamTest.assertEquals((String)"abc", (String)response1.getEntity().getText());
        Response response2 = this.get("decoded?decoded=%20");
        QueryParamTest.sysOutEntityIfError(response2);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response2.getStatus());
        QueryParamTest.assertEquals((String)" ", (String)response2.getEntity().getText());
    }

    public void testFieldEncoded() throws Exception {
        Response response1 = this.get("encoded?encoded=abc");
        QueryParamTest.sysOutEntityIfError(response1);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response1.getStatus());
        QueryParamTest.assertEquals((String)"abc", (String)response1.getEntity().getText());
        Response response2 = this.get("encoded?encoded=%20");
        QueryParamTest.sysOutEntityIfError(response2);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response2.getStatus());
        QueryParamTest.assertEquals((String)"%20", (String)response2.getEntity().getText());
    }

    public void testInt() throws Exception {
        Response response1 = this.get("int?n1=1&n2=2&n3=3");
        QueryParamTest.sysOutEntityIfError(response1);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response1.getStatus());
        QueryParamTest.assertEquals((String)"1 2 3", (String)response1.getEntity().getText());
        Response response2 = this.get("int?n1=1&n2=2");
        QueryParamTest.sysOutEntityIfError(response2);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response2.getStatus());
        QueryParamTest.assertEquals((String)"1 2 99", (String)response2.getEntity().getText());
        Response response5 = this.get("int?n2=2&n3=3");
        QueryParamTest.sysOutEntityIfError(response5);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response5.getStatus());
        QueryParamTest.assertEquals((String)"0 2 3", (String)response5.getEntity().getText());
        Response response4 = this.get("int?n1=1&n2=2&n3=");
        QueryParamTest.sysOutEntityIfError(response4);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response4.getStatus());
        QueryParamTest.assertEquals((String)"1 2 99", (String)response4.getEntity().getText());
        Response response6 = this.get("int?n1=1&n3=3");
        QueryParamTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response6.getStatus());
        Response response3 = this.get("int?n1=1&n2=2&n3");
        QueryParamTest.sysOutEntityIfError(response3);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response3.getStatus());
        QueryParamTest.assertEquals((String)"1 2 99", (String)response3.getEntity().getText());
    }

    public void testInteger() throws Exception {
        Response response1 = this.get("Integer?n1=1&n2=2&n3=3");
        QueryParamTest.sysOutEntityIfError(response1);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response1.getStatus());
        QueryParamTest.assertEquals((String)"1 2 3", (String)response1.getEntity().getText());
        Response response2 = this.get("Integer?n1=1&n2=2");
        QueryParamTest.sysOutEntityIfError(response2);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response2.getStatus());
        QueryParamTest.assertEquals((String)"1 2 99", (String)response2.getEntity().getText());
        Response response5 = this.get("Integer?n2=2&n3=3");
        QueryParamTest.sysOutEntityIfError(response5);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response5.getStatus());
        QueryParamTest.assertEquals((String)"null 2 3", (String)response5.getEntity().getText());
        Response response4 = this.get("Integer?n1=1&n2=2&n3=");
        QueryParamTest.sysOutEntityIfError(response4);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response4.getStatus());
        QueryParamTest.assertEquals((String)"1 2 99", (String)response4.getEntity().getText());
        Response response6 = this.get("Integer?n1=1&n3=3");
        QueryParamTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_FOUND, (Object)response6.getStatus());
        Response response3 = this.get("Integer?n1=1&n2=2&n3");
        QueryParamTest.sysOutEntityIfError(response3);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response3.getStatus());
        QueryParamTest.assertEquals((String)"1 2 99", (String)response3.getEntity().getText());
    }

    public void testMult1() throws Exception {
        this.checkMult("array", "[null]", "[1]", "[1, 2]");
        this.checkMult("arrayWithDefault", "[qv]", "[1]", "[1, 2]");
        this.checkMult("list", "[null]", "[1]", "[1, 2]");
        this.checkMult("listWithDefault", "[qv]", "[1]", "[1, 2]");
    }

    public void testOne1() throws Exception {
        Response response = this.get("one?name");
        QueryParamTest.sysOutEntityIfError(response);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        QueryParamTest.assertEquals((String)"[empty]", (String)response.getEntity().getText());
    }

    public void testOne2() throws Exception {
        Response response = this.get("one?name=");
        QueryParamTest.sysOutEntityIfError(response);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        QueryParamTest.assertEquals((String)"[empty]", (String)response.getEntity().getText());
    }

    public void testOne3() throws Exception {
        Response response = this.get("one?name=x");
        QueryParamTest.sysOutEntityIfError(response);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        QueryParamTest.assertEquals((String)"x", (String)response.getEntity().getText());
    }

    public void testOne4() throws Exception {
        Response response = this.get("one?name2=sdf");
        QueryParamTest.sysOutEntityIfError(response);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        QueryParamTest.assertEquals((String)"[null]", (String)response.getEntity().getText());
    }

    public void testQpDecoded() throws IOException {
        this.checkBothGiven("qpDecoded");
        this.checkOneGiven("qpDecoded");
    }

    public void testQpEncoded() throws IOException {
        Response response = this.get("qpEncoded?firstname=George%20U.&lastname=Bush");
        QueryParamTest.sysOutEntityIfError(response);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        QueryParamTest.assertEquals((String)"George%20U. Bush", (String)response.getEntity().getText());
        response = this.get("qpEncoded?lastname=Bush&firstname=George%20U.");
        QueryParamTest.sysOutEntityIfError(response);
        QueryParamTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        QueryParamTest.assertEquals((String)"George%20U. Bush", (String)response.getEntity().getText());
    }
}

