/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.test.ext.jaxrs.services.others.Person;
import org.restlet.test.ext.jaxrs.services.resources.RepresentationTestService;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;

public class RepresentationTest
extends JaxRsTestCase {
    @Override
    protected Application getApplication() {
        Application appConfig = new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(RepresentationTestService.class);
            }
        };
        return appConfig;
    }

    public void testDecodePost() throws IOException {
        StringRepresentation repr = new StringRepresentation((CharSequence)"abcde");
        Response response = this.post("reprDecode", (Representation)repr);
        RepresentationTest.sysOutEntityIfError(response);
        RepresentationTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        RepresentationTest.assertEquals((String)"abcde", (String)response.getEntity().getText());
    }

    public void testJaxbPost() throws IOException {
        Response response = this.post("jaxb", (Representation)null);
        RepresentationTest.sysOutEntityIfError(response);
        RepresentationTest.assertEquals((Object)Status.SUCCESS_NO_CONTENT, (Object)response.getStatus());
        RepresentationTest.assertEquals(null, (String)response.getEntity().getText());
    }

    public void testReprGet() {
        Response response = this.get("repr");
        RepresentationTest.sysOutEntityIfError(response);
        RepresentationTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
    }

    public void testReprPost() throws IOException {
        Response response = this.post("jaxb", (Representation)new StringRepresentation((CharSequence)"abcdef"));
        RepresentationTest.assertEquals((Object)Status.CLIENT_ERROR_UNSUPPORTED_MEDIA_TYPE, (Object)response.getStatus());
        response = this.post("jaxb", (Representation)new StringRepresentation((CharSequence)"<person firstname=\"Angela\" lastname=\"Merkel\"/>", MediaType.APPLICATION_XML));
        RepresentationTest.sysOutEntityIfError(response);
        RepresentationTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        String packageName = Person.class.getPackage().getName();
        RepresentationTest.assertEquals((String)packageName, (String)response.getEntity().getText());
    }

    public void testStringGet() {
        Response response = this.get("reprString");
        RepresentationTest.sysOutEntityIfError(response);
        RepresentationTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
    }
}

