/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.EntityTag;
import org.restlet.Response;
import org.restlet.data.ClientInfo;
import org.restlet.data.Conditions;
import org.restlet.data.Dimension;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Status;
import org.restlet.data.Tag;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.test.ext.jaxrs.services.resources.RequestService;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;
import org.restlet.test.ext.jaxrs.util.TestUtils;

public class RequestTest
extends JaxRsTestCase {
    public static final Date AFTER = new Date(109, 0, 9);
    public static final Date BEFORE = new Date(107, 11, 31);
    private static final Status PREC_FAILED = Status.CLIENT_ERROR_PRECONDITION_FAILED;

    private static Conditions createConditions(Date modifiedSince, Tag entityTag) {
        Conditions conditions = new Conditions();
        conditions.setModifiedSince(modifiedSince);
        conditions.setMatch(TestUtils.createList(entityTag));
        return conditions;
    }

    public static void main(String[] args) throws Exception {
        new RequestTest().runServerUntilKeyPressed();
    }

    private Tag getDatastoreETag() {
        return Converter.toRestletTag((EntityTag)RequestService.getEntityTagFromDatastore());
    }

    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(RequestService.class);
            }
        };
    }

    public void testDateAndEntityTag1Get() throws Exception {
        Conditions cond = RequestTest.createConditions(BEFORE, this.getDatastoreETag());
        Response response = this.get("date", cond);
        RequestTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
    }

    public void testDateAndEntityTag1Put() throws Exception {
        Conditions cond = RequestTest.createConditions(BEFORE, this.getDatastoreETag());
        Response response = this.put("date", null, cond);
        RequestTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
    }

    public void testDateAndEntityTag2Get() throws Exception {
        Conditions conditions = RequestTest.createConditions(AFTER, this.getDatastoreETag());
        Response response = this.get("date", conditions);
        RequestTest.assertEquals((Object)Status.REDIRECTION_NOT_MODIFIED, (Object)response.getStatus());
    }

    public void testDateAndEntityTag2Put() throws Exception {
        Conditions conditions = RequestTest.createConditions(AFTER, this.getDatastoreETag());
        Response response = this.put("date", null, conditions);
        RequestTest.assertEquals((Object)PREC_FAILED, (Object)response.getStatus());
    }

    public void testDateAndEntityTag3Get() throws Exception {
        Conditions conditions = RequestTest.createConditions(BEFORE, new Tag("shkhsdk"));
        Response response = this.get("date", conditions);
        RequestTest.assertEquals((Object)PREC_FAILED, (Object)response.getStatus());
    }

    public void testDateAndEntityTag3Put() throws Exception {
        Conditions conditions = RequestTest.createConditions(BEFORE, new Tag("shkhsdk"));
        Response response = this.put("date", null, conditions);
        RequestTest.assertEquals((Object)PREC_FAILED, (Object)response.getStatus());
    }

    public void testDateAndEntityTag4Get() throws Exception {
        Conditions conditions = RequestTest.createConditions(AFTER, new Tag("shkhsdk"));
        Response response = this.get("date", conditions);
        RequestTest.assertEquals((Object)PREC_FAILED, (Object)response.getStatus());
    }

    public void testDateAndEntityTag4Put() throws Exception {
        Conditions conditions = RequestTest.createConditions(AFTER, new Tag("shkhsdk"));
        Response response = this.put("date", null, conditions);
        RequestTest.assertEquals((Object)PREC_FAILED, (Object)response.getStatus());
    }

    public void testGetDateNotModified() throws Exception {
        Conditions conditions = new Conditions();
        conditions.setModifiedSince(AFTER);
        Response response = this.get("date", conditions);
        RequestTest.assertEquals((Object)Status.REDIRECTION_NOT_MODIFIED, (Object)response.getStatus());
        RequestTest.assertFalse((response.isEntityAvailable() && response.getEntity().getSize() != 0L ? 1 : 0) != 0);
    }

    public void testGetEntityTagMatch() throws Exception {
        Conditions conditions = new Conditions();
        conditions.setMatch(TestUtils.createList(this.getDatastoreETag()));
        Response response = this.get("date", conditions);
        RequestTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        RequestTest.assertEquals((Object)RequestService.getLastModificationDateFromDatastore(), (Object)response.getEntity().getModificationDate());
        RequestTest.assertEquals((Object)this.getDatastoreETag(), (Object)response.getEntity().getTag());
        RequestTest.assertNotNull((Object)response.getEntity().getText());
        RequestTest.assertTrue((response.getEntity().getSize() > 0L ? 1 : 0) != 0);
        conditions = new Conditions();
        conditions.setMatch(TestUtils.createList(new Tag("affer")));
        response = this.get("date", conditions);
        RequestTest.assertEquals((Object)PREC_FAILED, (Object)response.getStatus());
    }

    public void testGetEntityTagNoneMatch() throws Exception {
        Conditions conditions = new Conditions();
        conditions.setNoneMatch(TestUtils.createList(this.getDatastoreETag()));
        Response response = this.get("date", conditions);
        RequestTest.assertEquals((Object)Status.REDIRECTION_NOT_MODIFIED, (Object)response.getStatus());
        conditions = new Conditions();
        conditions.setNoneMatch(TestUtils.createList(new Tag("affer")));
        response = this.get("date", conditions);
        RequestTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
    }

    public void testGetModifiedSince() throws Exception {
        Conditions conditions = new Conditions();
        conditions.setModifiedSince(BEFORE);
        Response response = this.get("date", conditions);
        RequestTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        RequestTest.assertEquals((Object)RequestService.getLastModificationDateFromDatastore(), (Object)response.getEntity().getModificationDate());
        RequestTest.assertEquals((Object)this.getDatastoreETag(), (Object)response.getEntity().getTag());
        RequestTest.assertNotNull((Object)response.getEntity().getText());
        RequestTest.assertTrue((response.getEntity().getSize() > 0L ? 1 : 0) != 0);
        conditions = new Conditions();
        conditions.setModifiedSince(AFTER);
        response = this.get("date", conditions);
        RequestTest.assertEquals((Object)Status.REDIRECTION_NOT_MODIFIED, (Object)response.getStatus());
        RequestTest.assertEquals((Object)RequestService.getLastModificationDateFromDatastore(), (Object)response.getEntity().getModificationDate());
        RequestTest.assertEquals((Object)this.getDatastoreETag(), (Object)response.getEntity().getTag());
        RequestTest.assertEquals((long)0L, (long)response.getEntity().getSize());
    }

    public void testGetUnmodifiedSince() throws Exception {
        Conditions conditions = new Conditions();
        conditions.setUnmodifiedSince(AFTER);
        Response response = this.get("date", conditions);
        RequestTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        RequestTest.assertEquals((Object)RequestService.getLastModificationDateFromDatastore(), (Object)response.getEntity().getModificationDate());
        RequestTest.assertEquals((Object)this.getDatastoreETag(), (Object)response.getEntity().getTag());
        RequestTest.assertNotNull((Object)response.getEntity().getText());
        RequestTest.assertTrue((response.getEntity().getSize() > 0L ? 1 : 0) != 0);
        conditions = new Conditions();
        conditions.setUnmodifiedSince(BEFORE);
        response = this.get("date", conditions);
        RequestTest.assertEquals((Object)PREC_FAILED, (Object)response.getStatus());
    }

    public void testOptions() {
        Response response = this.options();
        Set allowedMethods = response.getAllowedMethods();
        RequestTest.assertEquals((int)3, (int)allowedMethods.size());
        RequestTest.assertTrue((String)"allowedOptions must contain ABC", (boolean)allowedMethods.contains(Method.valueOf((String)"ABC")));
        RequestTest.assertTrue((String)"allowedOptions must contain DEF", (boolean)allowedMethods.contains(Method.valueOf((String)"DEF")));
        RequestTest.assertTrue((String)"allowedOptions must contain GHI", (boolean)allowedMethods.contains(Method.valueOf((String)"GHI")));
        RequestTest.assertEquals((int)3, (int)allowedMethods.size());
    }

    public void testPutModifiedSince() throws Exception {
        Conditions conditions = new Conditions();
        conditions.setModifiedSince(BEFORE);
        Response response = this.put("date", null, conditions);
        RequestTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        conditions = new Conditions();
        conditions.setModifiedSince(AFTER);
        response = this.put("date", null, conditions);
        RequestTest.assertEquals((Object)PREC_FAILED, (Object)response.getStatus());
    }

    public void testPutUnmodifiedSince() throws Exception {
        Conditions conditions = new Conditions();
        conditions.setUnmodifiedSince(AFTER);
        Response response = this.put("date", null, conditions);
        RequestTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        conditions = new Conditions();
        conditions.setUnmodifiedSince(BEFORE);
        response = this.put("date", null, conditions);
        RequestTest.assertEquals((Object)PREC_FAILED, (Object)response.getStatus());
    }

    public void testSelectVariant() {
        ClientInfo clientInfo = new ClientInfo();
        List accLangs = clientInfo.getAcceptedLanguages();
        accLangs.add(new Preference((Metadata)Language.SPANISH, 1.0f));
        accLangs.add(new Preference((Metadata)new Language("de"), 0.8f));
        clientInfo.getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_HTML, 0.5f));
        Response response = this.get("selectVariants", clientInfo);
        RequestTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        RequestTest.assertEqualMediaType(MediaType.TEXT_HTML, response.getEntity().getMediaType());
        RequestTest.assertEquals((Object)new Language("de"), TestUtils.getOnlyElement(response.getEntity().getLanguages()));
        RequestTest.assertTrue((String)("dimensions must contain " + Dimension.MEDIA_TYPE), (boolean)response.getDimensions().contains(Dimension.MEDIA_TYPE));
        RequestTest.assertTrue((String)("dimensions must contain " + Dimension.LANGUAGE), (boolean)response.getDimensions().contains(Dimension.LANGUAGE));
        clientInfo.getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_PLAIN, 1.0f));
        response = this.get("selectVariants", clientInfo);
        RequestTest.assertEqualMediaType(MediaType.TEXT_PLAIN, response.getEntity().getMediaType());
        RequestTest.assertEquals((Object)new Language("de"), TestUtils.getOnlyElement(response.getEntity().getLanguages()));
        accLangs.add(new Preference((Metadata)Language.ENGLISH, 0.9f));
        response = this.get("selectVariants", clientInfo);
        RequestTest.assertEqualMediaType(MediaType.TEXT_PLAIN, response.getEntity().getMediaType());
        RequestTest.assertEquals((Object)Language.ENGLISH, TestUtils.getOnlyElement(response.getEntity().getLanguages()));
    }
}

