/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.test.ext.jaxrs.services.resources.SimpleHouse;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;

public class SimpleHouseTest
extends JaxRsTestCase {
    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(SimpleHouse.class);
            }
        };
    }

    public void testGetHtmlText() throws Exception {
        Response response = this.get(MediaType.TEXT_HTML);
        SimpleHouseTest.assertEquals((Object)Status.CLIENT_ERROR_NOT_ACCEPTABLE, (Object)response.getStatus());
    }

    public void testGetNull() throws Exception {
        Response response = this.get("null");
        SimpleHouseTest.assertEquals((Object)Status.SUCCESS_NO_CONTENT, (Object)response.getStatus());
        Representation entity = response.getEntity();
        if (entity != null) {
            SimpleHouseTest.assertEquals(null, (String)entity.getText());
        }
    }

    public void testGetNullWithMediaType() throws Exception {
        Response response = this.get("nullWithMediaType");
        SimpleHouseTest.assertEquals((Object)Status.SUCCESS_NO_CONTENT, (Object)response.getStatus());
        Representation entity = response.getEntity();
        if (entity != null) {
            SimpleHouseTest.assertEquals(null, (String)entity.getText());
        }
    }

    public void testGetPlainText() throws Exception {
        Response response = this.get(MediaType.TEXT_PLAIN);
        SimpleHouseTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation entity = response.getEntity();
        SimpleHouseTest.assertEquals((String)"  /\\ \n /  \\ \n |  | \n +--+ \n \n This is a simple text house", (String)entity.getText());
        SimpleHouseTest.assertEqualMediaType(MediaType.TEXT_PLAIN, entity.getMediaType());
    }

    public void testGetTextAll() throws Exception {
        Response response = this.get(MediaType.TEXT_ALL);
        SimpleHouseTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation entity = response.getEntity();
        SimpleHouseTest.assertEquals((String)"  /\\ \n /  \\ \n |  | \n +--+ \n \n This is a simple text house", (String)entity.getText());
        SimpleHouseTest.assertEqualMediaType(MediaType.TEXT_PLAIN, entity.getMediaType());
    }
}

