/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.test.ext.jaxrs.services.providers.SqlExceptionMapper;
import org.restlet.test.ext.jaxrs.services.resources.ThrowExceptionResource;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;

public class ThrowExceptionTest
extends JaxRsTestCase {
    @Override
    protected Application getApplication() {
        Application appConfig = new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(ThrowExceptionResource.class);
            }

            public Set<Object> getSingletons() {
                return Util.createSet((Object[])new SqlExceptionMapper[]{new SqlExceptionMapper()});
            }
        };
        return appConfig;
    }

    public void testIoe() {
        Response response = this.get("IOException");
        ThrowExceptionTest.assertEquals((Object)Status.SERVER_ERROR_INTERNAL, (Object)response.getStatus());
    }

    public void testSqlExc() throws Exception {
        Response response = this.get("sqlExc");
        ThrowExceptionTest.assertEquals((Object)Status.SERVER_ERROR_INTERNAL, (Object)response.getStatus());
        ThrowExceptionTest.assertEquals((String)"Database error", (String)response.getEntity().getText());
    }

    public void testWebAppExc() {
        Response response = this.get("WebAppExc");
        int actStatus = response.getStatus().getCode();
        ThrowExceptionTest.assertEquals((int)583, (int)actStatus);
    }

    public void testWebAppExcNullStatus() {
        Response response = this.get("WebAppExcNullStatus");
        ThrowExceptionTest.assertEquals((Object)Status.SERVER_ERROR_INTERNAL, (Object)response.getStatus());
    }
}

