/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.tests;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.test.ext.jaxrs.services.resources.UriBuilderTestResource;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;

public class UriBuilderByServiceTest
extends JaxRsTestCase {
    static void assertBaseUriAndMediaType(MediaType expectedMT, Response response, boolean checkEntityText, String baseRef) throws IOException {
        UriBuilderByServiceTest.sysOutEntityIfError(response);
        UriBuilderByServiceTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation entity = response.getEntity();
        UriBuilderByServiceTest.assertEqualMediaType(expectedMT, entity);
        if (checkEntityText) {
            while (baseRef.endsWith("/")) {
                baseRef = baseRef.substring(0, baseRef.length() - 1);
            }
            String entityRef = entity.getText();
            while (entityRef.endsWith("/")) {
                entityRef = baseRef.substring(0, entityRef.length() - 1);
            }
            UriBuilderByServiceTest.assertEquals((String)baseRef, (String)entityRef);
        }
    }

    static void assertUriAndMediaType(MediaType expectedMT, Response response, boolean checkEntityText, String reference) throws IOException {
        UriBuilderByServiceTest.sysOutEntityIfError(response);
        UriBuilderByServiceTest.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        Representation entity = response.getEntity();
        UriBuilderByServiceTest.assertEqualMediaType(expectedMT, entity.getMediaType());
        if (checkEntityText) {
            UriBuilderByServiceTest.assertEquals((String)reference.toString(), (String)entity.getText());
        }
    }

    private void assertBaseUriAndMediaType(MediaType expectedMT, Response response, boolean checkEntityText) throws IOException {
        UriBuilderByServiceTest.assertBaseUriAndMediaType(expectedMT, response, checkEntityText, this.createBaseRef().toString());
    }

    private void assertUriAndMediaType(String expectedSubPath, MediaType expectedMT, Response response, boolean checkEntityText) throws IOException {
        UriBuilderByServiceTest.assertUriAndMediaType(expectedMT, response, checkEntityText, this.createReference(expectedSubPath).toString());
    }

    @Override
    protected Application getApplication() {
        Application appConfig = new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(UriBuilderTestResource.class);
            }
        };
        return appConfig;
    }

    public void testAbsoluteGet() throws Exception {
        Response response = this.get("absolute", MediaType.TEXT_HTML);
        this.assertUriAndMediaType("absolute", MediaType.TEXT_HTML, response, true);
    }

    public void testAbsoluteHead() throws Exception {
        Response response = this.head("absolute", MediaType.TEXT_HTML);
        this.assertUriAndMediaType("absolute", MediaType.TEXT_HTML, response, false);
    }

    public void testAbsolutePost() throws Exception {
        Response response = this.post("absolute", MediaType.TEXT_HTML);
        this.assertUriAndMediaType("absolute", MediaType.TEXT_HTML, response, true);
    }

    public void testBaseGet() throws Exception {
        Response response = this.get("base", MediaType.TEXT_HTML);
        this.assertBaseUriAndMediaType(MediaType.TEXT_HTML, response, true);
    }

    public void testBaseHead() throws Exception {
        Response response = this.head("base", MediaType.TEXT_HTML);
        this.assertBaseUriAndMediaType(MediaType.TEXT_HTML, response, false);
    }

    public void testBasePost() throws Exception {
        Response response = this.post("base", MediaType.TEXT_HTML);
        this.assertBaseUriAndMediaType(MediaType.TEXT_HTML, response, true);
    }
}

