/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.util;

import java.lang.reflect.Constructor;
import javax.ws.rs.Path;
import junit.framework.TestCase;
import org.restlet.ext.jaxrs.internal.util.MatchingResult;
import org.restlet.ext.jaxrs.internal.util.PathRegExp;
import org.restlet.ext.jaxrs.internal.util.RemainingPath;

public class PathRegExpTests
extends TestCase {
    static final String ID1 = "id1";
    static final String ID2 = "id2";
    static final String PATH_PATTERN_1 = "/abc/{id1}/shf/{id2}/xyz";
    static final String PATH_PATTERN_2 = "/abc/{id1}/shf/{id2}/xyz/";
    static final String VALID_PATH_1 = "/abc/25478/shf/12345/xyz";
    static final RemainingPath VALID_PATH_1_RP = new RemainingPath("/abc/25478/shf/12345/xyz");
    public static final String VALID_PATH_2 = "/abc/25478/shf/12345/xyz/";
    public static final RemainingPath VALID_PATH_2_RP = new RemainingPath("/abc/25478/shf/12345/xyz/");
    private final PathRegExp regExpMultipleSegments1 = PathRegExpTests.newPathRegExp("/abc/{id1}/shf/{id2}/xyz");
    private final PathRegExp regExpMultipleSegments2 = PathRegExpTests.newPathRegExp("/abc/{id1}/shf/{id2}/xyz/");
    private final PathRegExp regExpOneSegment1 = PathRegExpTests.newPathRegExp("/abc/{id1}/shf/{id2}/xyz");
    private final PathRegExp regExpOneSegment2 = PathRegExpTests.newPathRegExp("/abc/{id1}/shf/{id2}/xyz/");

    private static final PathRegExp newPathRegExp(String pathPattern) {
        try {
            Class<PathRegExp> pathRegExpClass = PathRegExp.class;
            Constructor constructor = pathRegExpClass.getDeclaredConstructor(String.class, Path.class);
            constructor.setAccessible(true);
            return (PathRegExp)constructor.newInstance(pathPattern, null);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testMatchM1() {
        MatchingResult matchingResult = this.regExpMultipleSegments1.match(VALID_PATH_1_RP);
        PathRegExpTests.assertNotNull((Object)matchingResult);
        PathRegExpTests.assertEquals((String)"25478", (String)((String)matchingResult.getVariables().get(ID1)));
        PathRegExpTests.assertEquals((String)"12345", (String)((String)matchingResult.getVariables().get(ID2)));
        PathRegExpTests.assertEquals((Object)new RemainingPath(""), (Object)matchingResult.getFinalCapturingGroup());
        matchingResult = this.regExpMultipleSegments1.match(VALID_PATH_2_RP);
        PathRegExpTests.assertNotNull((Object)matchingResult);
        PathRegExpTests.assertEquals((String)"25478", (String)((String)matchingResult.getVariables().get(ID1)));
        PathRegExpTests.assertEquals((String)"12345", (String)((String)matchingResult.getVariables().get(ID2)));
        PathRegExpTests.assertEquals((Object)new RemainingPath(""), (Object)matchingResult.getFinalCapturingGroup());
    }

    public void testMatchM2() {
        MatchingResult matchingResult = this.regExpMultipleSegments2.match(VALID_PATH_1_RP);
        PathRegExpTests.assertNotNull((Object)matchingResult);
        PathRegExpTests.assertEquals((String)"25478", (String)((String)matchingResult.getVariables().get(ID1)));
        PathRegExpTests.assertEquals((String)"12345", (String)((String)matchingResult.getVariables().get(ID2)));
        matchingResult = this.regExpMultipleSegments2.match(VALID_PATH_2_RP);
        PathRegExpTests.assertNotNull((Object)matchingResult);
        PathRegExpTests.assertEquals((String)"25478", (String)((String)matchingResult.getVariables().get(ID1)));
        PathRegExpTests.assertEquals((String)"12345", (String)((String)matchingResult.getVariables().get(ID2)));
        PathRegExpTests.assertEquals((Object)new RemainingPath(""), (Object)matchingResult.getFinalCapturingGroup());
    }

    public void testMatchM3() {
        String rest = "/jkgjg";
        this.tryWithRest("/jkgjg");
    }

    public void testMatchM4() {
        String rest = "/qarear/iuguz/izu/";
        this.tryWithRest("/qarear/iuguz/izu/");
    }

    public void testMatchO1() {
        MatchingResult matchingResult = this.regExpOneSegment1.match(VALID_PATH_1_RP);
        PathRegExpTests.assertNotNull((Object)matchingResult);
        PathRegExpTests.assertEquals((String)"25478", (String)((String)matchingResult.getVariables().get(ID1)));
        PathRegExpTests.assertEquals((String)"12345", (String)((String)matchingResult.getVariables().get(ID2)));
        PathRegExpTests.assertEquals((Object)new RemainingPath(""), (Object)matchingResult.getFinalCapturingGroup());
        this.regExpOneSegment1.match(VALID_PATH_2_RP);
        PathRegExpTests.assertNotNull((Object)matchingResult);
        PathRegExpTests.assertEquals((String)"25478", (String)((String)matchingResult.getVariables().get(ID1)));
        PathRegExpTests.assertEquals((String)"12345", (String)((String)matchingResult.getVariables().get(ID2)));
        PathRegExpTests.assertEquals((Object)new RemainingPath(""), (Object)matchingResult.getFinalCapturingGroup());
    }

    public void testMatchO21() {
        MatchingResult matchingResult = this.regExpOneSegment2.match(VALID_PATH_1_RP);
        PathRegExpTests.assertNotNull((Object)matchingResult);
        PathRegExpTests.assertEquals((String)"25478", (String)((String)matchingResult.getVariables().get(ID1)));
        PathRegExpTests.assertEquals((String)"12345", (String)((String)matchingResult.getVariables().get(ID2)));
        matchingResult = this.regExpOneSegment2.match(VALID_PATH_2_RP);
        PathRegExpTests.assertNotNull((Object)matchingResult);
        PathRegExpTests.assertEquals((String)"25478", (String)((String)matchingResult.getVariables().get(ID1)));
        PathRegExpTests.assertEquals((String)"12345", (String)((String)matchingResult.getVariables().get(ID2)));
        PathRegExpTests.assertEquals((Object)new RemainingPath(""), (Object)matchingResult.getFinalCapturingGroup());
    }

    private void tryWithRest(String rest) {
        MatchingResult matchingResult = this.regExpMultipleSegments2.match(new RemainingPath(VALID_PATH_2 + rest));
        PathRegExpTests.assertNotNull((Object)matchingResult);
        PathRegExpTests.assertEquals((String)"25478", (String)((String)matchingResult.getVariables().get(ID1)));
        PathRegExpTests.assertEquals((String)"12345", (String)((String)matchingResult.getVariables().get(ID2)));
        PathRegExpTests.assertEquals((Object)new RemainingPath(rest), (Object)matchingResult.getFinalCapturingGroup());
    }
}

