/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.util;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.restlet.ext.jaxrs.internal.util.RemainingPath;

public class RemainingPathTests
extends TestCase {
    public void aear(String expected, String actual) {
        try {
            Method removeMatrixParams = RemainingPath.class.getDeclaredMethod("removeMatrixParams", String.class);
            removeMatrixParams.setAccessible(true);
            String removed = (String)removeMatrixParams.invoke(null, actual);
            RemainingPathTests.assertEquals((String)expected, (String)removed);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void testRemoveParams1() {
        this.aear("sdhfk/", "sdhfk;sdf");
        this.aear("sdhfk/", "sdhfk;sdf=1");
        this.aear("sdhfk/", "sdhfk;sdf=1?");
        this.aear("sdhfk/", "sdhfk;sdf=1?x");
        this.aear("sdhfk/", "sdhfk;sdf=1?x&");
        this.aear("sdhfk/", "sdhfk;sdf=1?x&;");
        this.aear("sdhfk/", "sdhfk;sdf=1?x&;/");
        this.aear("sdhfk/", "sdhfk;sdf=1?x&;c/");
        this.aear("sdhfk/", "sdhfk;sdf=1?x&;c/sdf");
    }

    public void testRemoveParams11() {
        this.aear("/ddf/", ";/ddf");
        this.aear("/ddf/", ";sdf/ddf");
        this.aear("/ddf/", ";sdf=/ddf");
        this.aear("/ddf/", ";sdf=sfsd/ddf");
        this.aear("/ddf/", ";sdf=sfsd;/ddf");
        this.aear("/ddf/", ";sdf=sfsd;sdf/ddf");
    }

    public void testRemoveParams3() {
        this.aear("sdhfk/gkjj/", "sdhfk;sdf/gkjj");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1/gkjj");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;/gkjj");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff/gkjj");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff=2/gkjj");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff=2/gkjj?");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff=2/gkjj?f");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff=2/gkjj?f=");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff=2/gkjj?f=5");
    }

    public void testRemoveParams5() {
        this.aear("sdhfk/gkjj/", "sdhfk/gkjj");
        this.aear("sdhfk/gkjj/", "sdhfk;/gkjj");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf/gkjj");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1/gkjj");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;/gkjj");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff/gkjj");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff=2/gkjj");
    }

    public void testRemoveParams7() {
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff=2/gkjj/");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff=2/gkjj;/");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff=2/gkjj;;/");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff=2/gkjj;dd/");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff=2/gkjj;dd=/");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff=2/gkjj;dd=we/");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff=2/gkjj;dd=we/;d");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff=2/gkjj;dd=we/;d=f");
        this.aear("sdhfk/gkjj/", "sdhfk;sdf=1;ff=2/gkjj;dd=we/;d=f;");
    }

    public void testRemoveParams9() {
        this.aear("sdhfk/gkjj/a/", "sdhfk;sdf=1;ff=2/gkjj/a");
    }

    public void testRemoveParamsEmptyResult1() {
        this.aear("/", ";");
        this.aear("/", ";df");
        this.aear("/", ";df=");
        this.aear("/", ";df=sdfsdf");
        this.aear("/", ";df=sdfsdf?");
        this.aear("/", ";df=sdfsdf?sdf");
        this.aear("/", ";df=sdfsdf?sdf=");
        this.aear("/", ";df=sdfsdf?sdf=sdffs");
    }

    public void testRemoveParamsEmptyResult2() {
        this.aear("/", "?");
        this.aear("/", "?df");
        this.aear("/", "?df=");
        this.aear("/", "?df=sdfsdf");
        this.aear("/", "?df=sdfsdf&");
        this.aear("/", "?df=sdfsdf&sdf");
        this.aear("/", "?df=sdfsdf&sdf=");
        this.aear("/", "?df=sdfsdf&sdf=sdffs");
        this.aear("/", "?df=sdfsdf?sdf=sdffs");
    }
}

