/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.util;

import javax.ws.rs.core.MultivaluedMap;
import junit.framework.TestCase;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.ext.jaxrs.internal.core.MultivaluedMapImpl;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalPathException;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.ext.jaxrs.internal.util.Util;

public class UtilTests
extends TestCase {
    private MultivaluedMap<String, Object> httpHeaders;

    private void checkPathTemplateWithoutRegExp(String expectedOut, String in) throws IllegalPathException {
        UtilTests.assertEquals((String)expectedOut, (String)Util.getPathTemplateWithoutRegExps((String)in, null));
    }

    private void checkPathTemplateWithoutRegExpIllegal(String in) {
        try {
            Util.getPathTemplateWithoutRegExps((String)in, null);
            UtilTests.fail((String)("\"" + in + "\" must not be allowed"));
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
    }

    private String getCss() {
        return Util.getCharsetName(this.httpHeaders, null);
    }

    private MediaType getMt() {
        MediaType mediaType = Util.getMediaType(this.httpHeaders);
        if (mediaType == null) {
            return null;
        }
        return Converter.getMediaTypeWithoutParams((MediaType)mediaType);
    }

    private String getMts() {
        MediaType mediaType = this.getMt();
        if (mediaType == null) {
            return null;
        }
        return mediaType.toString();
    }

    private void setContentType(MediaType mediaType, CharacterSet characterSet) {
        if (characterSet != null) {
            mediaType.getParameters().add("charset", characterSet.getName());
        }
        this.setContentType(mediaType.toString());
    }

    private void setContentType(String contentType) {
        this.httpHeaders.add((Object)"Content-Type", (Object)contentType);
    }

    public void setUp() {
        this.httpHeaders = new MultivaluedMapImpl();
    }

    protected void tearDown() throws Exception {
        this.httpHeaders = null;
        super.tearDown();
    }

    public void testDoesImplements() {
        UtilTests.assertTrue((boolean)Util.doesImplement(String.class, CharSequence.class));
        UtilTests.assertFalse((boolean)Util.doesImplement(CharSequence.class, String.class));
        UtilTests.assertFalse((boolean)Util.doesImplement(Object.class, CharSequence.class));
        UtilTests.assertTrue((boolean)Util.doesImplement(Integer.class, Comparable.class));
        UtilTests.assertFalse((boolean)Util.doesImplement(C1.class, I1.class));
        UtilTests.assertFalse((boolean)Util.doesImplement(C1.class, I2.class));
        UtilTests.assertTrue((boolean)Util.doesImplement(C2.class, I1.class));
        UtilTests.assertFalse((boolean)Util.doesImplement(C2.class, I2.class));
        UtilTests.assertTrue((boolean)Util.doesImplement(C3.class, I1.class));
        UtilTests.assertFalse((boolean)Util.doesImplement(C3.class, I2.class));
        UtilTests.assertTrue((boolean)Util.doesImplement(C4.class, I1.class));
        UtilTests.assertFalse((boolean)Util.doesImplement(C4.class, I2.class));
        UtilTests.assertTrue((boolean)Util.doesImplement(C5.class, I1.class));
        UtilTests.assertTrue((boolean)Util.doesImplement(C5.class, I2.class));
    }

    public void testGetOfContentType0() {
        UtilTests.assertEquals(null, (String)this.getCss());
        UtilTests.assertEquals(null, (String)this.getMts());
    }

    public void testGetOfContentType1() {
        this.setContentType("a/b;charset=CS");
        UtilTests.assertEquals((String)"CS", (String)this.getCss());
        UtilTests.assertEquals((String)"a/b", (String)this.getMts());
    }

    public void testGetOfContentType2() {
        this.setContentType(MediaType.TEXT_HTML, null);
        UtilTests.assertEquals(null, (String)this.getCss());
        UtilTests.assertEquals((Object)MediaType.TEXT_HTML, (Object)this.getMt());
    }

    public void testGetOfContentType3() {
        this.setContentType("a/b ;charset=CS");
        UtilTests.assertEquals((String)"CS", (String)this.getCss());
        UtilTests.assertEquals((String)"a/b", (String)this.getMts());
    }

    public void testGetOfContentType4() {
        this.setContentType("a/b;d=g;charset=CS");
        UtilTests.assertEquals((String)"CS", (String)this.getCss());
        UtilTests.assertEquals((String)"a/b", (String)this.getMts());
    }

    public void testGetPathTemplateWithoutRegExp() throws IllegalPathException {
        this.checkPathTemplateWithoutRegExp("abc", "abc");
        this.checkPathTemplateWithoutRegExp("abc{de}fg", "abc{de}fg");
        this.checkPathTemplateWithoutRegExp("abc{de}fg", "abc{de:sd}fg");
        this.checkPathTemplateWithoutRegExp("abc{de}fg", "abc{ de}fg");
        this.checkPathTemplateWithoutRegExp("abc{de}fg", "abc{ de }fg");
        this.checkPathTemplateWithoutRegExp("abc{de}fg", "abc{de }fg");
        this.checkPathTemplateWithoutRegExp("abc{de}fg", "abc{de :}fg");
        this.checkPathTemplateWithoutRegExp("abc{de}fg", "abc{de : }fg");
        this.checkPathTemplateWithoutRegExp("abc{de}fg", "abc{de : yx}fg");
        this.checkPathTemplateWithoutRegExp("abc{de}fg", "abc{de : yx }fg");
        this.checkPathTemplateWithoutRegExpIllegal("abc{}hjk");
        this.checkPathTemplateWithoutRegExpIllegal("abc{:}hjk");
        this.checkPathTemplateWithoutRegExpIllegal("abc{:sdf}hjk");
    }

    private static interface I2
    extends I1 {
    }

    private static interface I1 {
    }

    private static class C5
    extends C3
    implements I2 {
        private C5() {
        }
    }

    private static class C4
    extends C3 {
        private C4() {
        }
    }

    private static class C3
    implements I1 {
        private C3() {
        }
    }

    private static class C2
    extends C1
    implements I1 {
        private C2() {
        }
    }

    private static class C1 {
        private C1() {
        }
    }
}

