/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.json;

import org.junit.Assert;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.ext.json.JsonpFilter;
import org.restlet.ext.json.JsonpRepresentation;
import org.restlet.ext.xml.DomRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.test.RestletTestCase;

public class JsonpFilterTestCase
extends RestletTestCase {
    public void testAfterHandle() {
        JsonpFilter filter = new JsonpFilter(null);
        Reference ref = new Reference();
        String callback = "callback";
        ref.addQueryParameter("callback", "test");
        Request request = new Request(Method.GET, ref);
        Response response = new Response(request);
        String jsonString = "{'attribute': value}";
        response.setEntity((Representation)new JsonRepresentation("{'attribute': value}"));
        filter.afterHandle(request, response);
        Representation actual = response.getEntity();
        JsonpRepresentation expected = new JsonpRepresentation("callback", Status.SUCCESS_OK, (Representation)new JsonRepresentation("{'attribute': value}"));
        Assert.assertTrue((boolean)(actual instanceof JsonpRepresentation));
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((Object)Status.SUCCESS_OK, (Object)((JsonpRepresentation)actual).getStatus());
    }

    public void testAfterHandleText() {
        JsonpFilter filter = new JsonpFilter(null);
        Reference ref = new Reference();
        String callback = "callback";
        ref.addQueryParameter("callback", "test");
        Request request = new Request(Method.GET, ref);
        Response response = new Response(request);
        String jsonString = "{'attribute': value}";
        response.setEntity((Representation)new JsonRepresentation("{'attribute': value}"));
        filter.afterHandle(request, response);
        Representation actual = response.getEntity();
        JsonpRepresentation expected = new JsonpRepresentation("callback", Status.SUCCESS_OK, (Representation)new StringRepresentation((CharSequence)"{'attribute': value}", MediaType.TEXT_HTML));
        Assert.assertTrue((boolean)(actual instanceof JsonpRepresentation));
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals((Object)Status.SUCCESS_OK, (Object)((JsonpRepresentation)actual).getStatus());
    }

    public void testAfterHandle_without_callback_should_return_entity_unchanged() {
        JsonpFilter filter = new JsonpFilter(null);
        Reference ref = new Reference();
        Request request = new Request(Method.GET, ref);
        Response response = new Response(request);
        String jsonString = "{'attribute': value}";
        JsonRepresentation expected = new JsonRepresentation("{'attribute': value}");
        response.setEntity((Representation)expected);
        filter.afterHandle(request, response);
        Representation actual = response.getEntity();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    public void testAfterHandle_with_other_mediatype_should_return_entity_unchanged() throws Exception {
        JsonpFilter filter = new JsonpFilter(null);
        Reference ref = new Reference();
        String callback = "callback";
        ref.addQueryParameter("callback", "test");
        Request request = new Request(Method.GET, ref);
        Response response = new Response(request);
        DomRepresentation expected = new DomRepresentation(MediaType.APPLICATION_XML);
        response.setEntity((Representation)expected);
        filter.afterHandle(request, response);
        Representation actual = response.getEntity();
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

