/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.json;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.ext.json.JsonpRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.test.RestletTestCase;

public class JsonpRepresentationTestCase
extends RestletTestCase {
    public static final String CALLBACK = "callback";
    public static final String JSON_SAMPLE = "{'attribute': value}";
    public static final String JSONP_STATUS_BODY = "({status:,body:});";

    public void testGetSizeJson() throws Exception {
        JsonpRepresentation jsonpRepresentation = new JsonpRepresentation(CALLBACK, Status.SUCCESS_OK, (Representation)new JsonRepresentation(JSON_SAMPLE));
        long actual = jsonpRepresentation.getSize();
        long expected = JSON_SAMPLE.length() + Integer.toString(Status.SUCCESS_OK.getCode()).length() + CALLBACK.length() + JSONP_STATUS_BODY.length();
        Assert.assertEquals((long)expected, (long)actual);
    }

    public void testGetSize_with_text_is_UNKNOWN_SIZE() throws Exception {
        JsonpRepresentation jsonpRepresentation = new JsonpRepresentation(CALLBACK, Status.SUCCESS_OK, (Representation)new StringRepresentation((CharSequence)JSON_SAMPLE, MediaType.TEXT_HTML));
        long actual = jsonpRepresentation.getSize();
        long expected = -1L;
        Assert.assertEquals((long)expected, (long)actual);
    }

    public void testWrite() throws Exception {
        JsonpRepresentation jsonpRepresentation = new JsonpRepresentation(CALLBACK, Status.SUCCESS_OK, (Representation)new JsonRepresentation(JSON_SAMPLE));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        jsonpRepresentation.write((OutputStream)out);
        String expected = "callback({status:200,body:{'attribute': value}});";
        Assert.assertEquals((Object)expected, (Object)out.toString());
    }

    public void testWrite_with_text_then_apostrophe_are_escaped() throws Exception {
        JsonpRepresentation jsonpRepresentation = new JsonpRepresentation(CALLBACK, Status.SUCCESS_OK, (Representation)new StringRepresentation((CharSequence)"whatever'with'apostrophe'", MediaType.TEXT_HTML));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        jsonpRepresentation.write((OutputStream)out);
        String expected = "callback({status:200,body:'whatever\\'with\\'apostrophe\\''});";
        Assert.assertEquals((Object)expected, (Object)out.toString());
    }
}

