/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.odata;

import java.util.Iterator;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.ext.odata.Query;
import org.restlet.test.RestletTestCase;
import org.restlet.test.ext.odata.cafe.Cafe;
import org.restlet.test.ext.odata.cafe.CafeApplication;
import org.restlet.test.ext.odata.cafe.CafeService;
import org.restlet.test.ext.odata.cafe.Contact;
import org.restlet.test.ext.odata.cafe.Item;

public class ODataCafeTestCase
extends RestletTestCase {
    private Component component = new Component();
    private CafeService service;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.component.getServers().add(Protocol.HTTP, 8111);
        this.component.getClients().add(Protocol.CLAP);
        this.component.getDefaultHost().attach("/Cafe.svc", (Restlet)new CafeApplication());
        this.component.start();
        this.service = new CafeService();
    }

    @Override
    protected void tearDown() throws Exception {
        this.component.stop();
        this.component = null;
        super.tearDown();
    }

    public void testQueryCafes() {
        Query<Cafe> query = this.service.createCafeQuery("/Cafes");
        Iterator iterator = query.iterator();
        ODataCafeTestCase.assertTrue((boolean)iterator.hasNext());
        Cafe cafe = (Cafe)iterator.next();
        ODataCafeTestCase.assertEquals((String)"1", (String)cafe.getId());
        ODataCafeTestCase.assertEquals((String)"Le Cafe Louis", (String)cafe.getName());
        ODataCafeTestCase.assertEquals((String)"Cafe corp.", (String)cafe.getCompanyName());
        ODataCafeTestCase.assertEquals((String)"Levallois-Perret", (String)cafe.getCity());
        ODataCafeTestCase.assertEquals((int)92300, (int)cafe.getZipCode());
        ODataCafeTestCase.assertTrue((boolean)iterator.hasNext());
        cafe = (Cafe)iterator.next();
        ODataCafeTestCase.assertEquals((String)"2", (String)cafe.getId());
        ODataCafeTestCase.assertEquals((String)"Le Petit Marly", (String)cafe.getName());
        ODataCafeTestCase.assertEquals((String)"Cafe inc.", (String)cafe.getCompanyName());
        ODataCafeTestCase.assertEquals((String)"Marly Le Roi", (String)cafe.getCity());
        ODataCafeTestCase.assertEquals((int)78310, (int)cafe.getZipCode());
    }

    public void testQueryCafesExpandContact() {
        Query<Cafe> query1 = this.service.createCafeQuery("/Cafes");
        Query query2 = query1.expand("Contact");
        Iterator iterator = query2.iterator();
        ODataCafeTestCase.assertTrue((boolean)iterator.hasNext());
        Cafe cafe = (Cafe)iterator.next();
        ODataCafeTestCase.assertEquals((String)"1", (String)cafe.getId());
        ODataCafeTestCase.assertEquals((String)"Le Cafe Louis", (String)cafe.getName());
        ODataCafeTestCase.assertEquals((String)"Cafe corp.", (String)cafe.getCompanyName());
        ODataCafeTestCase.assertEquals((String)"Levallois-Perret", (String)cafe.getCity());
        ODataCafeTestCase.assertEquals((int)92300, (int)cafe.getZipCode());
        Contact contact = cafe.getContact();
        ODataCafeTestCase.assertNotNull((Object)contact);
        ODataCafeTestCase.assertEquals((String)"1", (String)contact.getId());
        ODataCafeTestCase.assertEquals((String)"Agathe Zeblues", (String)contact.getName());
        ODataCafeTestCase.assertEquals((String)"Chief", (String)contact.getTitle());
        ODataCafeTestCase.assertTrue((boolean)iterator.hasNext());
        cafe = (Cafe)iterator.next();
        ODataCafeTestCase.assertEquals((String)"2", (String)cafe.getId());
        ODataCafeTestCase.assertEquals((String)"Le Petit Marly", (String)cafe.getName());
        ODataCafeTestCase.assertEquals((String)"Cafe inc.", (String)cafe.getCompanyName());
        ODataCafeTestCase.assertEquals((String)"Marly Le Roi", (String)cafe.getCity());
        ODataCafeTestCase.assertEquals((int)78310, (int)cafe.getZipCode());
        contact = cafe.getContact();
        ODataCafeTestCase.assertNotNull((Object)contact);
        ODataCafeTestCase.assertEquals((String)"2", (String)contact.getId());
        ODataCafeTestCase.assertEquals((String)"Alphonse Denltas", (String)contact.getName());
        ODataCafeTestCase.assertEquals((String)"Boss", (String)contact.getTitle());
    }

    public void testQueryCafesExpandItem() {
        Query<Cafe> query1 = this.service.createCafeQuery("/Cafes");
        Query query2 = query1.expand("Items");
        Iterator iterator = query2.iterator();
        ODataCafeTestCase.assertTrue((boolean)iterator.hasNext());
        Cafe cafe = (Cafe)iterator.next();
        ODataCafeTestCase.assertEquals((String)"1", (String)cafe.getId());
        ODataCafeTestCase.assertEquals((String)"Le Cafe Louis", (String)cafe.getName());
        ODataCafeTestCase.assertEquals((String)"Cafe corp.", (String)cafe.getCompanyName());
        ODataCafeTestCase.assertEquals((String)"Levallois-Perret", (String)cafe.getCity());
        ODataCafeTestCase.assertEquals((int)92300, (int)cafe.getZipCode());
        Iterator<Item> iterator2 = cafe.getItems().iterator();
        ODataCafeTestCase.assertTrue((boolean)iterator2.hasNext());
        Item item = iterator2.next();
        ODataCafeTestCase.assertEquals((String)"1", (String)item.getId());
        ODataCafeTestCase.assertEquals((String)"Poulet au curry", (String)item.getDescription());
        ODataCafeTestCase.assertTrue((boolean)iterator2.hasNext());
        item = iterator2.next();
        ODataCafeTestCase.assertEquals((String)"2", (String)item.getId());
        ODataCafeTestCase.assertEquals((String)"Pate", (String)item.getDescription());
        ODataCafeTestCase.assertTrue((boolean)iterator.hasNext());
        cafe = (Cafe)iterator.next();
        ODataCafeTestCase.assertEquals((String)"2", (String)cafe.getId());
        ODataCafeTestCase.assertEquals((String)"Le Petit Marly", (String)cafe.getName());
        ODataCafeTestCase.assertEquals((String)"Cafe inc.", (String)cafe.getCompanyName());
        ODataCafeTestCase.assertEquals((String)"Marly Le Roi", (String)cafe.getCity());
        ODataCafeTestCase.assertEquals((int)78310, (int)cafe.getZipCode());
        iterator2 = cafe.getItems().iterator();
        ODataCafeTestCase.assertTrue((boolean)iterator2.hasNext());
        item = iterator2.next();
        ODataCafeTestCase.assertEquals((String)"3", (String)item.getId());
        ODataCafeTestCase.assertEquals((String)"Banana Split", (String)item.getDescription());
        ODataCafeTestCase.assertTrue((boolean)iterator2.hasNext());
        item = iterator2.next();
        ODataCafeTestCase.assertEquals((String)"4", (String)item.getId());
        ODataCafeTestCase.assertEquals((String)"Cotes du Rhone", (String)item.getDescription());
    }

    public void testQueryContact() {
        Query<Contact> query = this.service.createContactQuery("/Contacts('1')");
        Iterator iterator = query.iterator();
        ODataCafeTestCase.assertTrue((boolean)iterator.hasNext());
        Contact contact = (Contact)iterator.next();
        ODataCafeTestCase.assertNotNull((Object)contact);
        ODataCafeTestCase.assertEquals((String)"1", (String)contact.getId());
        ODataCafeTestCase.assertEquals((String)"Agathe Zeblues", (String)contact.getName());
        ODataCafeTestCase.assertEquals((String)"Chief", (String)contact.getTitle());
    }

    public void testServerPaging() {
        Query<Cafe> query1 = this.service.createCafeQuery("/Cafes");
        Query query2 = query1.skipToken("Skip1");
        Iterator iterator = query2.iterator();
        ODataCafeTestCase.assertTrue((boolean)iterator.hasNext());
        Cafe cafe = (Cafe)iterator.next();
        ODataCafeTestCase.assertEquals((String)"1", (String)cafe.getId());
        ODataCafeTestCase.assertEquals((String)"Le Cafe Louis", (String)cafe.getName());
        ODataCafeTestCase.assertEquals((String)"Cafe corp.", (String)cafe.getCompanyName());
        ODataCafeTestCase.assertEquals((String)"Levallois-Perret", (String)cafe.getCity());
        ODataCafeTestCase.assertEquals((int)92300, (int)cafe.getZipCode());
        ODataCafeTestCase.assertTrue((boolean)iterator.hasNext());
        cafe = (Cafe)iterator.next();
        ODataCafeTestCase.assertEquals((String)"2", (String)cafe.getId());
        ODataCafeTestCase.assertEquals((String)"Le Petit Marly", (String)cafe.getName());
        ODataCafeTestCase.assertEquals((String)"Cafe inc.", (String)cafe.getCompanyName());
        ODataCafeTestCase.assertEquals((String)"Marly Le Roi", (String)cafe.getCity());
        ODataCafeTestCase.assertEquals((int)78310, (int)cafe.getZipCode());
        ODataCafeTestCase.assertTrue((boolean)iterator.hasNext());
        cafe = (Cafe)iterator.next();
        ODataCafeTestCase.assertEquals((String)"1", (String)cafe.getId());
        ODataCafeTestCase.assertEquals((String)"Le Cafe Louis", (String)cafe.getName());
        ODataCafeTestCase.assertEquals((String)"Cafe corp.", (String)cafe.getCompanyName());
        ODataCafeTestCase.assertEquals((String)"Levallois-Perret", (String)cafe.getCity());
        ODataCafeTestCase.assertEquals((int)92300, (int)cafe.getZipCode());
        ODataCafeTestCase.assertTrue((boolean)iterator.hasNext());
        cafe = (Cafe)iterator.next();
        ODataCafeTestCase.assertEquals((String)"2", (String)cafe.getId());
        ODataCafeTestCase.assertEquals((String)"Le Petit Marly", (String)cafe.getName());
        ODataCafeTestCase.assertEquals((String)"Cafe inc.", (String)cafe.getCompanyName());
        ODataCafeTestCase.assertEquals((String)"Marly Le Roi", (String)cafe.getCity());
        ODataCafeTestCase.assertEquals((int)78310, (int)cafe.getZipCode());
    }
}

