/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.odata.deepexpand;

import org.junit.Assert;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.ext.odata.Query;
import org.restlet.test.RestletTestCase;
import org.restlet.test.ext.odata.deepexpand.ContainerService;
import org.restlet.test.ext.odata.deepexpand.feed.CoOpApplication;
import org.restlet.test.ext.odata.deepexpand.model.Benefits;
import org.restlet.test.ext.odata.deepexpand.model.Department;
import org.restlet.test.ext.odata.deepexpand.model.Division;
import org.restlet.test.ext.odata.deepexpand.model.Job;
import org.restlet.test.ext.odata.deepexpand.model.JobPart;
import org.restlet.test.ext.odata.deepexpand.model.JobPosting;
import org.restlet.test.ext.odata.deepexpand.model.Language;
import org.restlet.test.ext.odata.deepexpand.model.Literal;
import org.restlet.test.ext.odata.deepexpand.model.Multilingual;
import org.restlet.test.ext.odata.deepexpand.model.University;

public class ODataDeepExpandTestCase
extends RestletTestCase {
    private Component component = new Component();
    private ContainerService service;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.component.getServers().add(Protocol.HTTP, 8111);
        this.component.getClients().add(Protocol.CLAP);
        this.component.getDefaultHost().attach("/CoopOData.svc", (Restlet)new CoOpApplication());
        this.component.start();
        this.service = new ContainerService();
    }

    @Override
    protected void tearDown() throws Exception {
        this.component.stop();
        this.component = null;
        super.tearDown();
    }

    public void testQueryJobPostingsDeepExpandWithComplexProperty() {
        Query jobPostingQuery = this.service.createJobPostingQuery("/JobPosting").expand("name/literals/language").filter("benefits/transportationOffered eq true").top(10);
        for (JobPosting jobPosting : jobPostingQuery) {
            String jobPostingPath = String.format("/JobPostings(%d)", jobPosting.getId());
            this.assertFullExpansionOfMultilingualField(jobPosting.getName(), jobPostingPath + "/name");
            Benefits benefits = jobPosting.getBenefits();
            Assert.assertNotNull((String)"jobPosting.benefits shouldn't be null", (Object)benefits);
            Assert.assertTrue((String)"jobPosting.benefits.transportationOffered should be true", (boolean)benefits.getTransportationOffered());
        }
    }

    public void testQueryJobsDeepExpandAndMultiple() {
        Query query = this.service.createJobQuery("/Job").expand("jobParts/description/literals/language,jobPosting/name/literals/language");
        for (Job job : query) {
            String jobPostingPath = String.format("/Job(%d)/jobPosting", job.getId());
            JobPosting jobPosting = job.getJobPosting();
            Assert.assertNotNull((String)("Should have fetched " + jobPostingPath), (Object)jobPosting);
            this.assertFullExpansionOfMultilingualField(jobPosting.getName(), jobPostingPath + "/name");
            if (job.getJobParts() == null) continue;
            for (JobPart jobPart : job.getJobParts()) {
                String jobPartDescriptionPath = String.format("/Job(%d)/jobParts(%d)/description", job.getId(), jobPart.getId());
                this.assertFullExpansionOfMultilingualField(jobPart.getDescription(), jobPartDescriptionPath);
            }
        }
    }

    public void testQueryUniversitiesExpandDepartmentsDivisionsAndAllNames() {
        Query query = this.service.createUniversityQuery("University").expand("name/literals/language,departments/name/literals/language,departments/divisions/name/literals/language");
        for (University university : query) {
            String universityPath = String.format("/University(%d)", university.getId());
            this.assertFullExpansionOfMultilingualField(university.getName(), universityPath + "/name");
            for (Department department : university.getDepartments()) {
                String departmentPath = String.format("%s/departments(%d)", universityPath, department.getId());
                this.assertFullExpansionOfMultilingualField(department.getName(), departmentPath + "/name");
                for (Division division : department.getDivisions()) {
                    String divisionPath = String.format("%s/divisions(%d)", departmentPath, division.getId());
                    this.assertFullExpansionOfMultilingualField(division.getName(), divisionPath + "/name");
                }
            }
        }
    }

    private void assertFullExpansionOfMultilingualField(Multilingual multilingual, String basePath) {
        String baseMessage = "Should have fetched " + basePath;
        Assert.assertNotNull((String)baseMessage, (Object)multilingual);
        Assert.assertNotNull((String)(baseMessage + "/literals"), multilingual.getLiterals());
        for (Literal literal : multilingual.getLiterals()) {
            Assert.assertNotNull((String)(baseMessage + "/literals(?)"), (Object)literal);
            Language language = literal.getLanguage();
            Assert.assertNotNull((String)String.format("%s/literals(%d)/language", baseMessage, literal.getId()), (Object)language);
            Assert.assertTrue((String)String.format("%s/literals(%d)/language/@id should be greater than zero", basePath, literal.getId()), (language.getId() > 0 ? 1 : 0) != 0);
            String languagePath = String.format("%s/literals(%d)/language(%d)", basePath, literal.getId(), language.getId());
            switch (language.getId()) {
                case 1: {
                    Assert.assertTrue((String)(languagePath + "/@localeCode shoule be \"el\""), (boolean)"el".equals(language.getLocaleCode()));
                    break;
                }
                case 2: {
                    Assert.assertTrue((String)(languagePath + "/@localeCode shoule be \"en\""), (boolean)"en".equals(language.getLocaleCode()));
                    Assert.assertTrue((String)(languagePath + "/@name shoule be \"English\""), (boolean)"English".equals(language.getName()));
                }
            }
        }
    }
}

