/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.spring;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Method;
import org.restlet.ext.spring.SpringBeanFinder;
import org.restlet.ext.spring.SpringBeanRouter;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Filter;
import org.restlet.routing.Route;
import org.restlet.routing.Template;
import org.restlet.routing.TemplateRoute;
import org.restlet.security.ChallengeAuthenticator;
import org.restlet.test.RestletTestCase;
import org.restlet.util.Resolver;
import org.restlet.util.RouteList;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class SpringBeanRouterTestCase
extends RestletTestCase {
    private static final String FISH_URI = "/renewable/fish/{fish_name}";
    private static final String ORE_URI = "/non-renewable/ore/{ore_type}";
    private DefaultListableBeanFactory factory;
    private SpringBeanRouter router;

    private RouteList actualRoutes() {
        this.doPostProcess();
        return this.router.getRoutes();
    }

    private void assertFinderForBean(String expectedBeanName, Restlet restlet) {
        SpringBeanRouterTestCase.assertTrue((String)("Restlet is not a bean finder restlet: " + restlet.getClass().getName()), (boolean)(restlet instanceof SpringBeanFinder));
        SpringBeanFinder actualFinder = (SpringBeanFinder)restlet;
        SpringBeanRouterTestCase.assertEquals((String)"Finder does not point to correct bean", (String)expectedBeanName, (String)actualFinder.getBeanName());
        SpringBeanRouterTestCase.assertEquals((String)"Finder does not point to correct bean factory", (Object)this.factory, (Object)actualFinder.getBeanFactory());
    }

    private void doPostProcess() {
        this.router.postProcessBeanFactory((ConfigurableListableBeanFactory)this.factory);
    }

    private TemplateRoute matchRouteFor(String uri) {
        Request req = new Request(Method.GET, new Template(uri).format((Resolver)new Resolver<String>(){

            public String resolve(String name) {
                return name;
            }
        }));
        return (TemplateRoute)this.router.getNext(req, new Response(req));
    }

    private void registerBeanDefinition(String id, String alias, Class<?> beanClass, String scope) {
        RootBeanDefinition bd = new RootBeanDefinition(beanClass);
        bd.setScope(scope == null ? "singleton" : scope);
        this.factory.registerBeanDefinition(id, (BeanDefinition)bd);
        if (alias != null) {
            this.factory.registerAlias(id, alias);
        }
    }

    private void registerServerResourceBeanDefinition(String id, String alias) {
        this.registerBeanDefinition(id, alias, ServerResource.class, "prototype");
    }

    private Set<String> routeUris(RouteList routes) {
        HashSet<String> uris = new HashSet<String>();
        for (Route actualRoute : routes) {
            if (!(actualRoute instanceof TemplateRoute)) continue;
            uris.add(((TemplateRoute)actualRoute).getTemplate().getPattern());
        }
        return uris;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.factory = new DefaultListableBeanFactory();
        this.registerServerResourceBeanDefinition("ore", ORE_URI);
        this.registerServerResourceBeanDefinition("fish", FISH_URI);
        this.registerBeanDefinition("someOtherBean", null, String.class, null);
        this.router = new SpringBeanRouter();
    }

    @Override
    protected void tearDown() throws Exception {
        this.factory = null;
        this.router = null;
        super.tearDown();
    }

    public void testExplicitAttachmentsMayBeRestlets() throws Exception {
        String expected = "/protected/timber";
        this.router.setAttachments(Collections.singletonMap(expected, "timber"));
        this.registerBeanDefinition("timber", null, TestAuthenticator.class, null);
        this.doPostProcess();
        TemplateRoute timberRoute = this.matchRouteFor(expected);
        SpringBeanRouterTestCase.assertNotNull((String)("No route for " + expected), (Object)timberRoute);
        SpringBeanRouterTestCase.assertTrue((String)"Route is not for correct restlet", (boolean)(timberRoute.getNext() instanceof TestAuthenticator));
    }

    public void testExplicitAttachmentsTrumpBeanNames() throws Exception {
        this.router.setAttachments(Collections.singletonMap(ORE_URI, "fish"));
        RouteList actualRoutes = this.actualRoutes();
        SpringBeanRouterTestCase.assertEquals((String)"Wrong number of routes", (int)2, (int)actualRoutes.size());
        TemplateRoute oreRoute = this.matchRouteFor(ORE_URI);
        SpringBeanRouterTestCase.assertNotNull((String)"No route for /non-renewable/ore/{ore_type}", (Object)oreRoute);
        this.assertFinderForBean("fish", oreRoute.getNext());
    }

    public void testExplicitRoutingForNonResourceNonRestletBeansFails() throws Exception {
        this.router.setAttachments(Collections.singletonMap("/fail", "someOtherBean"));
        try {
            this.doPostProcess();
            SpringBeanRouterTestCase.fail((String)"Exception not thrown");
        }
        catch (IllegalStateException ise) {
            SpringBeanRouterTestCase.assertEquals((String)"someOtherBean is not routable.  It must be either a Resource, a ServerResource or a Restlet.", (String)ise.getMessage());
        }
    }

    public void testRoutesCreatedForBeanIdsIfAppropriate() throws Exception {
        String grain = "/renewable/grain/{grain_type}";
        this.registerServerResourceBeanDefinition(grain, null);
        Set<String> actualUris = this.routeUris(this.actualRoutes());
        SpringBeanRouterTestCase.assertEquals((String)"Wrong number of URIs", (int)3, (int)actualUris.size());
        SpringBeanRouterTestCase.assertTrue((String)("Missing grain URI: " + actualUris), (boolean)actualUris.contains(grain));
    }

    public void testRoutesCreatedForUrlAliases() throws Exception {
        Set<String> actualUris = this.routeUris(this.actualRoutes());
        SpringBeanRouterTestCase.assertEquals((String)"Wrong number of URIs", (int)2, (int)actualUris.size());
        SpringBeanRouterTestCase.assertTrue((String)("Missing ore URI: " + actualUris), (boolean)actualUris.contains(ORE_URI));
        SpringBeanRouterTestCase.assertTrue((String)("Missing fish URI: " + actualUris), (boolean)actualUris.contains(FISH_URI));
    }

    public void testRoutesPointToFindersForBeans() throws Exception {
        RouteList actualRoutes = this.actualRoutes();
        SpringBeanRouterTestCase.assertEquals((String)"Wrong number of routes", (int)2, (int)actualRoutes.size());
        TemplateRoute oreRoute = this.matchRouteFor(ORE_URI);
        TemplateRoute fishRoute = this.matchRouteFor(FISH_URI);
        SpringBeanRouterTestCase.assertNotNull((String)("ore route not present: " + actualRoutes), (Object)oreRoute);
        SpringBeanRouterTestCase.assertNotNull((String)("fish route not present: " + actualRoutes), (Object)fishRoute);
        this.assertFinderForBean("ore", oreRoute.getNext());
        this.assertFinderForBean("fish", fishRoute.getNext());
    }

    public void testRoutingIncludesAuthenticators() throws Exception {
        String expected = "/protected/timber";
        this.registerBeanDefinition("timber", expected, TestAuthenticator.class, null);
        this.doPostProcess();
        TemplateRoute authenticatorRoute = this.matchRouteFor(expected);
        SpringBeanRouterTestCase.assertNotNull((String)"No route for authenticator", (Object)authenticatorRoute);
        SpringBeanRouterTestCase.assertTrue((String)"Route is not for authenticator", (boolean)(authenticatorRoute.getNext() instanceof TestAuthenticator));
    }

    public void testRoutingIncludesFilters() throws Exception {
        String expected = "/filtered/timber";
        this.registerBeanDefinition("timber", expected, TestFilter.class, null);
        this.doPostProcess();
        TemplateRoute filterRoute = this.matchRouteFor(expected);
        SpringBeanRouterTestCase.assertNotNull((String)"No route for filter", (Object)filterRoute);
        SpringBeanRouterTestCase.assertTrue((String)"Route is not for filter", (boolean)(filterRoute.getNext() instanceof Filter));
    }

    public void testRoutingIncludesOtherRestlets() throws Exception {
        String expected = "/singleton";
        this.registerBeanDefinition("timber", expected, TestRestlet.class, null);
        this.doPostProcess();
        TemplateRoute restletRoute = this.matchRouteFor(expected);
        SpringBeanRouterTestCase.assertNotNull((String)"No route for restlet", (Object)restletRoute);
        SpringBeanRouterTestCase.assertTrue((String)"Route is not for restlet", (boolean)(restletRoute.getNext() instanceof TestRestlet));
    }

    public void testRoutingIncludesResourceSubclasses() throws Exception {
        String expected = "/renewable/timber/{id}";
        this.registerBeanDefinition("timber", expected, TestResource.class, "prototype");
        this.doPostProcess();
        TemplateRoute timberRoute = this.matchRouteFor("/renewable/timber/sycamore");
        SpringBeanRouterTestCase.assertNotNull((String)"No route for timber", (Object)timberRoute);
        this.assertFinderForBean("timber", timberRoute.getNext());
    }

    public void testRoutingIncludesSpringRouterStyleExplicitlyMappedBeans() throws Exception {
        RootBeanDefinition bd = new RootBeanDefinition(ServerResource.class);
        bd.setScope("prototype");
        this.factory.registerBeanDefinition("timber", (BeanDefinition)bd);
        this.factory.registerAlias("timber", "no-slash");
        String expectedTemplate = "/renewable/timber/{farm_type}";
        this.router.setAttachments(Collections.singletonMap(expectedTemplate, "timber"));
        RouteList actualRoutes = this.actualRoutes();
        SpringBeanRouterTestCase.assertEquals((String)"Wrong number of routes", (int)3, (int)actualRoutes.size());
        TemplateRoute timberRoute = this.matchRouteFor(expectedTemplate);
        SpringBeanRouterTestCase.assertNotNull((String)("Missing timber route: " + actualRoutes), (Object)timberRoute);
        this.assertFinderForBean("timber", timberRoute.getNext());
    }

    public void testRoutingSkipsResourcesWithoutAppropriateAliases() throws Exception {
        RootBeanDefinition bd = new RootBeanDefinition(ServerResource.class);
        bd.setScope("prototype");
        this.factory.registerBeanDefinition("timber", (BeanDefinition)bd);
        this.factory.registerAlias("timber", "no-slash");
        RouteList actualRoutes = this.actualRoutes();
        SpringBeanRouterTestCase.assertEquals((String)"Timber resource should have been skipped", (int)2, (int)actualRoutes.size());
    }

    private static class TestRestlet
    extends Restlet {
        private TestRestlet() {
        }
    }

    private static class TestResource
    extends ServerResource {
        private TestResource() {
        }
    }

    private static class TestFilter
    extends Filter {
        private TestFilter() {
        }
    }

    private static class TestAuthenticator
    extends ChallengeAuthenticator {
        private TestAuthenticator() throws IllegalArgumentException {
            super(null, ChallengeScheme.HTTP_BASIC, "Test");
        }
    }
}

