/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.xml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.LocalReference;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.ext.xml.TransformRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.test.RestletTestCase;

public class ResolvingTransformerTestCase
extends RestletTestCase {
    private static final String MY_BASEPATH;
    private static final String MY_NAME;
    private static final String MY_PATH;

    public void testResolving() throws Exception {
        Component comp = new Component();
        StringRepresentation xml = new StringRepresentation((CharSequence)"<?xml version='1.0'><simpleroot/>", MediaType.TEXT_XML);
        StringRepresentation xslt = new StringRepresentation((CharSequence)"<?xml version=\"1.0\"?><xsl:transform xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'><xsl:template match ='/'><newroot/></xsl:template></xsl:transform>", MediaType.TEXT_XML);
        TransformRepresentation transRep = new TransformRepresentation(comp.getContext(), (Representation)xml, (Representation)xslt);
        String testCode = "rnd." + new Random().nextInt();
        String testData = "\"The resolver is doing OK\", said the testclass " + MY_NAME + ".";
        StringRepresentation testRep = new StringRepresentation((CharSequence)testData);
        SimpleUriMapApplication testApp = new SimpleUriMapApplication();
        testApp.add(testCode, (Representation)testRep);
        comp.getInternalRouter().attach("/testApp/", (Restlet)testApp);
        String testBase = "riap://component/testApp";
        URIResolver uriResolver = transRep.getUriResolver();
        ResolvingTransformerTestCase.assertNotNull((String)"no resolver present!", (Object)uriResolver);
        String baseUri = testBase + "/dummy";
        AssertResolvingHelper test = new AssertResolvingHelper(baseUri, uriResolver);
        String absoluteUri = testBase + "/" + testCode;
        test.assertResolving("error in absolute resolving.", absoluteUri, testData);
        String relUri = testCode;
        test.assertResolving("error in relative resolving.", relUri, testData);
        String relLocalUri = "./" + testCode;
        test.assertResolving("error in relative resolving to ./", relLocalUri, testData);
        String relParentUri = "../testApp/" + testCode;
        test.assertResolving("error in relative resolving to ../", relParentUri, testData);
    }

    public void testTransform() throws Exception {
        Component comp = new Component();
        comp.getClients().add(Protocol.CLAP);
        String thirdDocData = "<data3>" + "rnd." + new Random().nextInt() + "</data3>";
        String xsl2xmlLink = "./3rd.xml";
        StringRepresentation xml3 = new StringRepresentation((CharSequence)("<?xml version='1.0' ?>" + thirdDocData), MediaType.TEXT_XML);
        StringRepresentation xslt3 = new StringRepresentation((CharSequence)("<?xml version=\"1.0\"?><xsl:transform xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'>  <xsl:template match ='el3'>    <xsl:variable name='external' select=\"document('" + xsl2xmlLink + "')\" />" + "    <xsl:copy-of select='$external/data3' />" + "  </xsl:template>" + "</xsl:transform>"), MediaType.TEXT_XML);
        SimpleUriMapApplication thirdLevel = new SimpleUriMapApplication();
        thirdLevel.add("3rd.xsl", (Representation)xslt3);
        thirdLevel.add("3rd.xml", (Representation)xml3);
        comp.getInternalRouter().attach("/three/", (Restlet)thirdLevel);
        StringRepresentation xmlIn = new StringRepresentation((CharSequence)"<?xml version='1.0' ?><input><one/><any attTwo='2'/><el3>drie</el3></input>");
        LocalReference xsltOneRef = new LocalReference("clap://thread/" + MY_BASEPATH + "/xslt/one/1st.xsl");
        Representation xsltOne = comp.getContext().getClientDispatcher().handle(new Request(Method.GET, (Reference)xsltOneRef)).getEntity();
        TransformRepresentation tr = new TransformRepresentation(comp.getContext(), (Representation)xmlIn, xsltOne);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        tr.write((OutputStream)out);
        String xmlOut = out.toString();
        String expectedResult = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><output><data1>1st</data1><data2>2nd</data2>" + thirdDocData + "</output>";
        ResolvingTransformerTestCase.assertEquals((String)"xslt result doesn't match expectations", (String)expectedResult, (String)xmlOut);
    }

    static {
        MY_PATH = ResolvingTransformerTestCase.class.getName().replace('.', '/');
        int lastPos = MY_PATH.lastIndexOf(47);
        MY_NAME = MY_PATH.substring(lastPos);
        MY_BASEPATH = MY_PATH.substring(0, lastPos);
    }

    class SimpleUriMapApplication
    extends Application {
        private final Map<String, Representation> uriMap = new HashMap<String, Representation>();

        public SimpleUriMapApplication() {
            this.getTunnelService().setExtensionsTunnel(false);
        }

        void add(String uri, Representation rep) {
            this.uriMap.put(uri, rep);
        }

        public Restlet createInboundRoot() {
            return new Restlet(){

                public void handle(Request request, Response response) {
                    String remainder = request.getResourceRef().getRemainingPart();
                    Representation answer = (Representation)SimpleUriMapApplication.this.uriMap.get(remainder);
                    if (answer != null) {
                        response.setEntity(answer);
                    }
                }
            };
        }
    }

    class AssertResolvingHelper {
        String baseUri;
        URIResolver resolver;

        AssertResolvingHelper(String baseUri, URIResolver resolver) {
            this.baseUri = baseUri;
            this.resolver = resolver;
        }

        void assertResolving(String message, String testUri, String testData) throws TransformerException, IOException {
            Source resolvedSource = this.resolver.resolve(testUri, this.baseUri);
            TestCase.assertNotNull((String)("resolved source for " + testUri + " should not be null"), (Object)resolvedSource);
            StringBuilder data = new StringBuilder();
            if (resolvedSource instanceof StreamSource) {
                StreamSource streamSource = (StreamSource)resolvedSource;
                Reader dataReader = streamSource.getReader();
                if (dataReader == null) {
                    InputStream in = streamSource.getInputStream();
                    TestCase.assertNotNull((String)"no reader or inputstream available", (Object)in);
                    dataReader = new InputStreamReader(in);
                }
                TestCase.assertNotNull((String)"no reader to data in source.", (Object)dataReader);
                char[] buf = new char[1024];
                int len = 0;
                while ((len = dataReader.read(buf)) != -1) {
                    data.append(buf, 0, len);
                }
                dataReader.close();
            } else {
                TestCase.fail((String)"test implementation currently doesn't handle other source (e.g. sax) implementations");
            }
            TestCase.assertEquals((String)message, (String)testData, (String)data.toString());
        }
    }
}

