/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.xml;

import org.restlet.data.MediaType;
import org.restlet.ext.xml.TransformRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.test.RestletTestCase;

public class TransformRepresentationTestCase
extends RestletTestCase {
    final String output1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><buyer>cust123</buyer>";
    final String output2 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><myBuyer>cust123</myBuyer>";
    final Representation source = new StringRepresentation((CharSequence)"<?xml version=\"1.0\"?><purchase id=\"p001\"><customer db=\"cust123\"/><product db=\"prod345\"><amount>23.45</amount></product></purchase>", MediaType.TEXT_XML);
    final Representation xslt1 = new StringRepresentation((CharSequence)"<?xml version=\"1.0\"?><xsl:transform xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"><xsl:template match =\"customer\"><buyer><xsl:value-of select=\"@db\"/></buyer></xsl:template><xsl:template match =\"amount\"/></xsl:transform>", MediaType.TEXT_XML);
    final Representation xslt2 = new StringRepresentation((CharSequence)"<?xml version=\"1.0\"?><xsl:transform xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"><xsl:template match =\"buyer\"><myBuyer><xsl:value-of select=\"text()\"/></myBuyer></xsl:template></xsl:transform>", MediaType.TEXT_XML);

    public void testSingleTransform() throws Exception {
        TransformRepresentation tr1 = new TransformRepresentation(this.source, this.xslt1);
        String result = tr1.getText();
        TransformRepresentationTestCase.assertEquals((String)this.output1, (String)result);
    }

    public void testDoubleTransform() throws Exception {
        TransformRepresentation tr1 = new TransformRepresentation(this.source, this.xslt1);
        TransformRepresentation tr2 = new TransformRepresentation((Representation)tr1, this.xslt2);
        String result = tr2.getText();
        TransformRepresentationTestCase.assertEquals((String)this.output2, (String)result);
    }
}

