/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.client;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.lang.ClassUtils;
import org.restlet.Request;
import org.restlet.data.Cookie;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.resource.AnnotationUtils;
import org.restlet.engine.resource.ClientInvocationHandler;
import org.restlet.ext.jaxrs.internal.client.JaxRsAnnotationUtils;
import org.restlet.ext.jaxrs.internal.exceptions.IllegalMethodParamTypeException;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.util.Series;

public class JaxRsClientInvocationHandler<T>
extends ClientInvocationHandler<T> {
    private ClientResource clientResource;

    public JaxRsClientInvocationHandler(ClientResource clientResource, Class<? extends T> resourceInterface) {
        super(clientResource, resourceInterface, (AnnotationUtils)JaxRsAnnotationUtils.getInstance());
        this.clientResource = clientResource;
    }

    private void addCookieParam(Request request, String representationAsText, Annotation annotation) {
        Series cookies = request.getCookies();
        if (cookies == null) {
            cookies = new Series(Cookie.class);
        }
        cookies.add((Object)new Cookie(((CookieParam)annotation).value(), representationAsText));
        request.setCookies(cookies);
    }

    private void addHeaderParam(Request request, String representationAsText, Annotation annotation) {
        Util.getHttpHeaders(request).add(((HeaderParam)annotation).value(), representationAsText);
    }

    private void addPathParam(Request request, String representationAsText, Annotation annotation) {
        String paramName = ((PathParam)annotation).value();
        String existingPath = Reference.decode((String)request.getResourceRef().getPath());
        String simplePathParam = String.format("{%s}", paramName);
        if (existingPath.contains(simplePathParam)) {
            existingPath = existingPath.replace(simplePathParam, Reference.encode((String)representationAsText));
        }
        request.getResourceRef().setPath(existingPath);
    }

    private void addQueryParam(Request request, String representationAsText, Annotation annotation) {
        request.getResourceRef().addQueryParameter(new Parameter(((QueryParam)annotation).value(), representationAsText));
    }

    private String getRepresentationAsText(Object value) {
        boolean isPrimitiveOrWrapped;
        Class<?> clazz = value.getClass();
        boolean bl = isPrimitiveOrWrapped = clazz.isPrimitive() || ClassUtils.wrapperToPrimitive(clazz) != null;
        if (isPrimitiveOrWrapped || clazz == String.class) {
            return String.valueOf(value);
        }
        String representationAsText = null;
        try {
            Representation representation = this.clientResource.getApplication().getConverterService().toRepresentation(value);
            representationAsText = representation.getText();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e);
        }
        return representationAsText;
    }

    protected Request getRequest(Method javaMethod, Object[] args) throws Throwable {
        Request request = super.getRequest(javaMethod, args);
        this.setRequestPathToAnnotationPath(javaMethod, request);
        this.setRequestParams(javaMethod, args, request);
        return request;
    }

    private void setRequestParams(Method javaMethod, Object[] args, Request request) throws IllegalMethodParamTypeException {
        Annotation[][] parameterAnnotations;
        int argIndex = 0;
        for (Annotation[] annotations : parameterAnnotations = javaMethod.getParameterAnnotations()) {
            String representationAsText = this.getRepresentationAsText(args[argIndex]);
            if (representationAsText == null) continue;
            for (Annotation annotation : annotations) {
                if (annotation instanceof HeaderParam) {
                    this.addHeaderParam(request, representationAsText, annotation);
                    ++argIndex;
                    continue;
                }
                if (annotation instanceof QueryParam) {
                    this.addQueryParam(request, representationAsText, annotation);
                    ++argIndex;
                    continue;
                }
                if (annotation instanceof FormParam) {
                    ++argIndex;
                    continue;
                }
                if (annotation instanceof CookieParam) {
                    this.addCookieParam(request, representationAsText, annotation);
                    ++argIndex;
                    continue;
                }
                if (annotation instanceof MatrixParam) {
                    ++argIndex;
                    continue;
                }
                if (!(annotation instanceof PathParam)) continue;
                this.addPathParam(request, representationAsText, annotation);
                ++argIndex;
            }
        }
    }

    private void setRequestPathToAnnotationPath(Method javaMethod, Request request) {
        String methodPath;
        Path methodPathAnnotation = javaMethod.getAnnotation(Path.class);
        if (methodPathAnnotation != null && (methodPath = methodPathAnnotation.value()) != null && methodPath.length() > 0) {
            request.getResourceRef().setPath(request.getResourceRef().getPath() + "/" + methodPath);
        }
    }
}

