/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.ssl.internal;

import java.security.cert.Certificate;
import java.util.List;
import org.restlet.Context;
import org.restlet.Server;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.HttpInboundRequest;
import org.restlet.ext.ssl.internal.SslConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpsInboundRequest
extends HttpInboundRequest {
    public HttpsInboundRequest(Context context, Connection<Server> connection, String methodName, String resourceUri, String version) {
        super(context, connection, methodName, resourceUri, version);
        Integer keySize;
        String cipherSuite;
        List<Certificate> clientCertificates = this.getConnection().getSslClientCertificates();
        if (clientCertificates != null) {
            this.getAttributes().put("org.restlet.https.clientCertificates", clientCertificates);
        }
        if ((cipherSuite = this.getConnection().getSslCipherSuite()) != null) {
            this.getAttributes().put("org.restlet.https.cipherSuite", cipherSuite);
        }
        if ((keySize = this.getConnection().getSslKeySize()) != null) {
            this.getAttributes().put("org.restlet.https.keySize", keySize);
        }
    }

    public SslConnection<Server> getConnection() {
        return (SslConnection)super.getConnection();
    }
}

