/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.security;

import java.io.IOException;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.AuthenticationInfo;
import org.restlet.data.ChallengeMessage;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.Engine;
import org.restlet.engine.http.HeaderBuilder;
import org.restlet.engine.http.HeaderReader;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.security.Guard;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticatorUtils {
    public static boolean anyNull(Object ... objects) {
        for (Object o : objects) {
            if (o != null) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static int authenticate(Request request, Guard guard) {
        ChallengeResponse cr;
        int result = 0;
        if (guard.getScheme() != null && (cr = request.getChallengeResponse()) != null && guard.getScheme().equals(cr.getScheme())) {
            AuthenticatorHelper helper = Engine.getInstance().findHelper(cr.getScheme(), false, true);
            if (helper != null) {
                result = helper.authenticate(cr, request, guard);
            } else {
                throw new IllegalArgumentException("Challenge scheme " + guard.getScheme() + " not supported by the Restlet engine.");
            }
        }
        if (request.getChallengeResponse() != null) {
            request.getChallengeResponse().setAuthenticated(result == 1);
        }
        request.getClientInfo().setAuthenticated(result == 1);
        return result;
    }

    @Deprecated
    public static void challenge(Response response, boolean stale, Guard guard) {
        AuthenticatorHelper helper = Engine.getInstance().findHelper(guard.getScheme(), false, true);
        if (helper == null) {
            throw new IllegalArgumentException("Challenge scheme " + guard.getScheme() + " not supported by the Restlet engine.");
        }
        helper.challenge(response, stale, guard);
    }

    public static String formatAuthenticationInfo(AuthenticationInfo info) throws IOException {
        HeaderBuilder hb = new HeaderBuilder();
        boolean firstParameter = true;
        if (info != null) {
            if (info.getNextServerNonce() != null && info.getNextServerNonce().length() > 0) {
                hb.setFirstParameter(firstParameter);
                hb.appendQuotedParameter("nextnonce", info.getNextServerNonce());
                firstParameter = false;
            }
            if (info.getQuality() != null && info.getQuality().length() > 0) {
                hb.setFirstParameter(firstParameter);
                hb.appendParameter("qop", info.getQuality());
                firstParameter = false;
                if (info.getNonceCount() > 0) {
                    hb.appendParameter("nc", AuthenticatorUtils.formatNonceCount(info.getNonceCount()));
                }
            }
            if (info.getResponseDigest() != null && info.getResponseDigest().length() > 0) {
                hb.setFirstParameter(firstParameter);
                hb.appendQuotedParameter("rspauth", info.getResponseDigest());
                firstParameter = false;
            }
            if (info.getClientNonce() != null && info.getClientNonce().length() > 0) {
                hb.setFirstParameter(firstParameter);
                hb.appendParameter("cnonce", info.getClientNonce());
                firstParameter = false;
            }
        }
        return hb.toString();
    }

    public static String formatNonceCount(int nonceCount) {
        StringBuilder result = new StringBuilder(Integer.toHexString(nonceCount));
        while (result.length() < 8) {
            result.insert(0, '0');
        }
        return result.toString();
    }

    public static String formatRequest(ChallengeRequest challenge, Response response, Series<Parameter> httpHeaders) {
        String result = null;
        if (challenge != null) {
            AuthenticatorHelper helper = Engine.getInstance().findHelper(challenge.getScheme(), false, true);
            if (helper != null) {
                try {
                    result = helper.formatRequest(challenge, response, httpHeaders);
                }
                catch (IOException e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to format the challenge request: " + challenge, e);
                }
            } else {
                result = "?";
                Context.getCurrentLogger().warning("Challenge scheme " + challenge.getScheme() + " not supported by the Restlet engine.");
            }
        }
        return result;
    }

    public static String formatResponse(ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) throws IOException {
        String result = null;
        AuthenticatorHelper helper = Engine.getInstance().findHelper(challenge.getScheme(), true, false);
        if (helper != null) {
            result = helper.formatResponse(challenge, request, httpHeaders);
        } else {
            result = "?";
            Context.getCurrentLogger().warning("Challenge scheme " + challenge.getScheme() + " not supported by the Restlet engine.");
        }
        return result;
    }

    public static AuthenticationInfo parseAuthenticationInfo(String header) {
        AuthenticationInfo result = null;
        HeaderReader hr = new HeaderReader(header);
        try {
            String nextNonce = null;
            String qop = null;
            String responseAuth = null;
            String cnonce = null;
            int nonceCount = 0;
            Parameter param = hr.readParameter();
            while (param != null) {
                try {
                    if ("nextnonce".equals(param.getName())) {
                        nextNonce = param.getValue();
                    } else if ("qop".equals(param.getName())) {
                        qop = param.getValue();
                    } else if ("rspauth".equals(param.getName())) {
                        responseAuth = param.getValue();
                    } else if ("cnonce".equals(param.getName())) {
                        cnonce = param.getValue();
                    } else if ("nc".equals(param.getName())) {
                        nonceCount = Integer.parseInt(param.getValue(), 16);
                    }
                    param = hr.readParameter();
                }
                catch (Exception e) {
                    Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the authentication info header parameter", e);
                }
            }
            result = new AuthenticationInfo(nextNonce, nonceCount, cnonce, qop, responseAuth);
        }
        catch (IOException e) {
            Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the authentication info header: " + header, e);
        }
        return result;
    }

    private static ChallengeMessage parseMessage(boolean isChallengeResponse, Request request, Response response, String header, Series<Parameter> httpHeaders) {
        int space;
        ChallengeMessage result = null;
        if (header != null && (space = header.indexOf(32)) != -1) {
            String scheme = header.substring(0, space);
            String rawValue = header.substring(space + 1);
            result = isChallengeResponse ? new ChallengeResponse(new ChallengeScheme("HTTP_" + scheme, scheme)) : new ChallengeRequest(new ChallengeScheme("HTTP_" + scheme, scheme));
            result.setRawValue(rawValue);
        }
        if (result != null) {
            AuthenticatorHelper helper = Engine.getInstance().findHelper(result.getScheme(), true, false);
            if (helper != null) {
                if (isChallengeResponse) {
                    helper.parseResponse((ChallengeResponse)result, request, httpHeaders);
                } else {
                    helper.parseRequest((ChallengeRequest)result, response, httpHeaders);
                }
            } else {
                Context.getCurrentLogger().warning("Couldn't find any helper support the " + result.getScheme() + " challenge scheme.");
            }
        }
        return result;
    }

    public static ChallengeRequest parseRequest(Response response, String header, Series<Parameter> httpHeaders) {
        return (ChallengeRequest)AuthenticatorUtils.parseMessage(false, null, response, header, httpHeaders);
    }

    public static ChallengeResponse parseResponse(Request request, String header, Series<Parameter> httpHeaders) {
        return (ChallengeResponse)AuthenticatorUtils.parseMessage(true, request, null, header, httpHeaders);
    }

    public static void update(ChallengeResponse challengeResponse, Request request, Response response) {
        ChallengeMessage challengeRequest = null;
        for (ChallengeRequest c : response.getChallengeRequests()) {
            if (!challengeResponse.getScheme().equals(c.getScheme())) continue;
            challengeRequest = c;
            break;
        }
        String realm = null;
        String nonce = null;
        if (challengeRequest != null) {
            realm = challengeRequest.getRealm();
            nonce = challengeRequest.getServerNonce();
            challengeResponse.setOpaque(challengeRequest.getOpaque());
        }
        challengeResponse.setRealm(realm);
        challengeResponse.setServerNonce(nonce);
        challengeResponse.setDigestRef(new Reference(request.getResourceRef().getPath()));
    }

    public static void update(ChallengeResponse challengeResponse, Request previousRequest, Response previousResponse, String identifier, char[] baseSecret, String baseSecretAlgorithm) {
        AuthenticatorUtils.update(challengeResponse, previousRequest, previousResponse);
        AuthenticatorHelper helper = Engine.getInstance().findHelper(challengeResponse.getScheme(), false, true);
        challengeResponse.setSecret(helper.formatSecret(challengeResponse, previousRequest, previousResponse, identifier, baseSecret, baseSecretAlgorithm));
    }

    private AuthenticatorUtils() {
    }
}

