/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.security;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.engine.http.HeaderBuilder;
import org.restlet.engine.http.HeaderReader;
import org.restlet.engine.security.AuthenticatorHelper;
import org.restlet.engine.util.Base64;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpBasicHelper
extends AuthenticatorHelper {
    public HttpBasicHelper() {
        super(ChallengeScheme.HTTP_BASIC, true, true);
    }

    @Override
    public void formatRawRequest(HeaderBuilder hb, ChallengeRequest challenge, Response response, Series<Parameter> httpHeaders) throws IOException {
        if (challenge.getRealm() != null) {
            hb.appendQuotedParameter("realm", challenge.getRealm());
        }
    }

    @Override
    public void formatRawResponse(HeaderBuilder hb, ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        try {
            CharArrayWriter credentials = new CharArrayWriter();
            credentials.write(challenge.getIdentifier());
            credentials.write(":");
            credentials.write(challenge.getSecret());
            hb.append(Base64.encode(credentials.toCharArray(), "US-ASCII", false));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding, unable to encode credentials");
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception, unable to encode credentials", e);
        }
    }

    @Override
    public void parseRequest(ChallengeRequest challenge, Response response, Series<Parameter> httpHeaders) {
        if (challenge.getRawValue() != null) {
            HeaderReader hr = new HeaderReader(challenge.getRawValue());
            try {
                Parameter param = hr.readParameter();
                while (param != null) {
                    try {
                        if ("realm".equals(param.getName())) {
                            challenge.setRealm(param.getValue());
                        } else {
                            challenge.getParameters().add(param);
                        }
                        param = hr.readParameter();
                    }
                    catch (Exception e) {
                        Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the challenge request header parameter", e);
                    }
                }
            }
            catch (Exception e) {
                Context.getCurrentLogger().log(Level.WARNING, "Unable to parse the challenge request header parameter", e);
            }
        }
    }

    @Override
    public void parseResponse(ChallengeResponse challenge, Request request, Series<Parameter> httpHeaders) {
        try {
            String credentials;
            int separator;
            byte[] credentialsEncoded = Base64.decode(challenge.getRawValue());
            if (credentialsEncoded == null) {
                this.getLogger().warning("Cannot decode credentials: " + challenge.getRawValue());
            }
            if ((separator = (credentials = new String(credentialsEncoded, "US-ASCII")).indexOf(58)) == -1) {
                this.getLogger().warning("Invalid credentials given by client with IP: " + (request != null ? request.getClientInfo().getAddress() : "?"));
            } else {
                challenge.setIdentifier(credentials.substring(0, separator));
                challenge.setSecret(credentials.substring(separator + 1));
            }
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().log(Level.WARNING, "Unsupported encoding error", e);
        }
    }
}

