/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.util;

import java.util.ArrayList;
import java.util.List;
import org.restlet.data.CharacterSet;
import org.restlet.data.ClientInfo;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Preference;
import org.restlet.representation.Variant;
import org.restlet.service.MetadataService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conneg {
    private volatile List<Preference<CharacterSet>> characterSetPrefs;
    private volatile ClientInfo clientInfo;
    private volatile List<Preference<Encoding>> encodingPrefs;
    private volatile List<Preference<Language>> languagePrefs;
    private volatile List<Preference<MediaType>> mediaTypePrefs;
    private volatile MetadataService metadataService;

    public Conneg(ClientInfo clientInfo, MetadataService metadataService) {
        this.clientInfo = clientInfo;
        this.metadataService = metadataService;
        if (clientInfo != null) {
            this.languagePrefs = this.getEnrichedPreferences(clientInfo.getAcceptedLanguages(), metadataService == null ? null : metadataService.getDefaultLanguage(), Language.ALL);
            this.mediaTypePrefs = this.getEnrichedPreferences(clientInfo.getAcceptedMediaTypes(), metadataService == null ? null : metadataService.getDefaultMediaType(), MediaType.ALL);
            this.characterSetPrefs = this.getEnrichedPreferences(clientInfo.getAcceptedCharacterSets(), metadataService == null ? null : metadataService.getDefaultCharacterSet(), CharacterSet.ALL);
            this.encodingPrefs = this.getEnrichedPreferences(clientInfo.getAcceptedEncodings(), metadataService == null ? null : metadataService.getDefaultEncoding(), Encoding.ALL);
        }
    }

    protected List<Preference<CharacterSet>> getCharacterSetPrefs() {
        return this.characterSetPrefs;
    }

    protected ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    protected List<Preference<Encoding>> getEncodingPrefs() {
        return this.encodingPrefs;
    }

    protected <T extends Metadata> List<Preference<T>> getEnrichedPreferences(List<Preference<T>> userPreferences, T defaultValue, T allValue) {
        int i;
        ArrayList<Preference<T>> result = new ArrayList<Preference<T>>();
        result.addAll(userPreferences);
        for (i = 0; i < result.size(); ++i) {
            Metadata parent = ((Metadata)((Preference)result.get(i)).getMetadata()).getParent();
            if (parent == null) continue;
            result.add(new Preference<Metadata>(parent, 0.005f + 0.001f * ((Preference)result.get(i)).getQuality()));
        }
        if (defaultValue != null) {
            Preference<T> defaultPref = new Preference<T>(defaultValue, 0.003f);
            result.add(defaultPref);
            Metadata defaultParent = defaultValue.getParent();
            if (defaultParent != null) {
                result.add(new Preference<Metadata>(defaultParent, 0.002f));
            }
        }
        for (i = result.size() - 1; i >= 0; --i) {
            if (!((Metadata)((Preference)result.get(i)).getMetadata()).equals(allValue)) continue;
            result.remove(i);
        }
        result.add(new Preference<T>(allValue, 0.001f));
        return result;
    }

    protected List<Preference<Language>> getLanguagePrefs() {
        return this.languagePrefs;
    }

    protected List<Preference<MediaType>> getMediaTypePrefs() {
        return this.mediaTypePrefs;
    }

    protected MetadataService getMetadataService() {
        return this.metadataService;
    }

    public Variant getPreferredVariant(List<Variant> variants) {
        Variant result = null;
        if (variants != null && !variants.isEmpty()) {
            float bestScore = -1.0f;
            for (Variant variant : variants) {
                float current = this.scoreVariant(variant);
                if (!(current > bestScore)) continue;
                bestScore = current;
                result = variant;
            }
        }
        return result;
    }

    public float scoreCharacterSet(CharacterSet characterSet) {
        return this.scoreMetadata(characterSet, this.getCharacterSetPrefs());
    }

    public float scoreEncodings(List<Encoding> encodings) {
        return this.scoreMetadata((Metadata)((Object)encodings), this.getEncodingPrefs());
    }

    public float scoreLanguages(List<Language> languages) {
        return this.scoreMetadata((Metadata)((Object)languages), this.getLanguagePrefs());
    }

    public float scoreMediaType(MediaType mediaType) {
        return this.scoreMetadata(mediaType, this.getMediaTypePrefs());
    }

    private <T extends Metadata> float scoreMetadata(List<T> metadataList, List<Preference<T>> prefs) {
        float result = -1.0f;
        if (metadataList != null && !metadataList.isEmpty()) {
            for (Preference<T> pref : prefs) {
                for (Metadata metadata : metadataList) {
                    float current = ((Metadata)pref.getMetadata()).includes(metadata) ? pref.getQuality() : -1.0f;
                    if (!(current > result)) continue;
                    result = current;
                }
            }
        } else {
            result = 0.0f;
        }
        return result;
    }

    private <T extends Metadata> float scoreMetadata(T metadata, List<Preference<T>> prefs) {
        float result = -1.0f;
        if (metadata != null) {
            for (Preference<T> pref : prefs) {
                float current = ((Metadata)pref.getMetadata()).includes(metadata) ? pref.getQuality() : -1.0f;
                if (!(current > result)) continue;
                result = current;
            }
        } else {
            result = 0.0f;
        }
        return result;
    }

    public float scoreVariant(Variant variant) {
        float encodingScore;
        float characterSetScore;
        float mediaTypeScore;
        float result = -1.0f;
        float languageScore = this.scoreLanguages(variant.getLanguages());
        if (languageScore != -1.0f && (mediaTypeScore = this.scoreMediaType(variant.getMediaType())) != -1.0f && (characterSetScore = this.scoreCharacterSet(variant.getCharacterSet())) != -1.0f && (encodingScore = this.scoreEncodings(variant.getEncodings())) != -1.0f) {
            result = (languageScore * 4.0f + mediaTypeScore * 3.0f + characterSetScore * 2.0f + encodingScore) / 9.0f;
        }
        return result;
    }
}

