/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.engine.io.ByteUtils;
import org.restlet.representation.CharacterRepresentation;

public class ReaderRepresentation
extends CharacterRepresentation {
    private volatile Reader reader;

    public ReaderRepresentation(Reader reader) {
        this(reader, null);
    }

    public ReaderRepresentation(Reader reader, MediaType mediaType) {
        this(reader, mediaType, -1L);
    }

    public ReaderRepresentation(Reader reader, MediaType mediaType, long expectedSize) {
        super(mediaType);
        this.setSize(expectedSize);
        this.setTransient(true);
        this.setReader(reader);
    }

    public Reader getReader() throws IOException {
        Reader result = this.reader;
        this.setReader(null);
        return result;
    }

    public String getText() throws IOException {
        return ByteUtils.toString(this.getStream(), this.getCharacterSet());
    }

    public void release() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                Context.getCurrentLogger().log(Level.WARNING, "Error while releasing the representation.", e);
            }
            this.reader = null;
        }
        super.release();
    }

    public void setReader(Reader reader) {
        this.reader = reader;
        this.setAvailable(reader != null);
    }

    public void write(Writer writer) throws IOException {
        ByteUtils.write(this.getReader(), writer);
    }
}

