/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom;

import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.ext.atom.Feed;
import org.restlet.ext.atom.MemberType;
import org.restlet.ext.atom.Workspace;
import org.restlet.resource.Representation;
import org.restlet.util.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Collection {
    private volatile Reference href;
    private volatile MemberType memberType;
    private volatile String title;
    private volatile Workspace workspace;

    public Collection(Workspace workspace, String title, String href) {
        this.workspace = workspace;
        this.title = title;
        this.href = new Reference(href);
        this.memberType = null;
    }

    public Feed getFeed() throws Exception {
        Reference feedRef = this.getHref();
        if (feedRef.isRelative()) {
            feedRef.setBaseRef(this.getWorkspace().getService().getReference());
        }
        Request request = new Request(Method.GET, feedRef.getTargetRef());
        Response response = this.getWorkspace().getService().getClientDispatcher().handle(request);
        if (response.getStatus().equals((Object)Status.SUCCESS_OK)) {
            return new Feed(response.getEntity());
        }
        throw new Exception("Couldn't get the feed representation. Status returned: " + response.getStatus().getDescription());
    }

    public Reference getHref() {
        return this.href;
    }

    public MemberType getMemberType() {
        return this.memberType;
    }

    public String getTitle() {
        return this.title;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Reference postMember(Representation member) throws Exception {
        Request request = new Request(Method.POST, this.getHref(), member);
        Response response = this.getWorkspace().getService().getClientDispatcher().handle(request);
        if (response.getStatus().equals((Object)Status.SUCCESS_CREATED)) {
            return response.getLocationRef();
        }
        throw new Exception("Couldn't post the member representation. Status returned: " + response.getStatus().getDescription());
    }

    public void setHref(Reference href) {
        this.href = href;
    }

    public void setMemberType(MemberType memberType) {
        this.memberType = memberType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        if (this.getHref() != null && this.getHref().toString() != null) {
            attributes.addAttribute("", "href", null, "atomURI", this.getHref().toString());
        }
        writer.startElement("http://www.w3.org/2007/app", "collection", null, (Attributes)attributes);
        if (this.getTitle() != null) {
            writer.dataElement("http://www.w3.org/2005/Atom", "title", this.getTitle());
        }
        if (this.getMemberType() != null) {
            this.getMemberType().writeElement(writer, "http://www.w3.org/2007/app");
        }
        try {
            if (this.getFeed() != null) {
                this.getFeed().writeElement(writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        writer.endElement("http://www.w3.org/2007/app", "collection");
    }
}

