/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom;

import java.io.IOException;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.resource.Representation;
import org.restlet.util.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Content {
    private volatile Reference externalRef = null;
    private volatile MediaType externalType = null;
    private volatile Representation inlineContent = null;

    public Reference getExternalRef() {
        return this.externalRef;
    }

    public MediaType getExternalType() {
        return this.externalType;
    }

    public Representation getInlineContent() {
        return this.inlineContent;
    }

    public boolean isExternal() {
        return this.externalRef != null;
    }

    public boolean isInline() {
        return this.inlineContent != null;
    }

    public void setExternalRef(Reference externalRef) {
        this.externalRef = externalRef;
    }

    public void setExternalType(MediaType externalType) {
        this.externalType = externalType;
    }

    public void setInlineContent(Representation inlineContent) {
        this.inlineContent = inlineContent;
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        String strContent = null;
        if (this.getInlineContent() != null) {
            MediaType mediaType = this.getInlineContent().getMediaType();
            String type = null;
            if (mediaType != null && mediaType.getSubType() != null) {
                type = mediaType.getSubType().contains("xhtml") ? "xhtml" : (mediaType.getSubType().contains("html") ? "html" : mediaType.getName());
            }
            if (type == null) {
                type = "text";
            }
            attributes.addAttribute("", "type", null, "text", type);
            try {
                strContent = this.getInlineContent().getText();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            if (this.getExternalType() != null && this.getExternalType().toString() != null) {
                attributes.addAttribute("", "type", null, "atomMediaType", this.getExternalType().toString());
            }
            if (this.getExternalRef() != null && this.getExternalRef().toString() != null) {
                attributes.addAttribute("", "src", null, "atomURI", this.getExternalRef().toString());
            }
        }
        if (strContent == null) {
            writer.emptyElement("http://www.w3.org/2005/Atom", "content", null, (Attributes)attributes);
        } else {
            writer.dataElement("http://www.w3.org/2005/Atom", "content", null, (Attributes)attributes, strContent);
        }
    }
}

