/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.restlet.ext.atom.Category;
import org.restlet.ext.atom.Content;
import org.restlet.ext.atom.Link;
import org.restlet.ext.atom.Person;
import org.restlet.ext.atom.Relation;
import org.restlet.ext.atom.Source;
import org.restlet.ext.atom.Text;
import org.restlet.util.DateUtils;
import org.restlet.util.XmlWriter;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entry {
    private volatile List<Person> authors = null;
    private volatile List<Category> categories = null;
    private volatile Content content = null;
    private volatile List<Person> contributors = null;
    private volatile String id = null;
    private volatile List<Link> links = null;
    private volatile Date published = null;
    private volatile Text rights = null;
    private volatile Source source = null;
    private volatile String summary = null;
    private volatile Text title = null;
    private volatile Date updated = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Person> getAuthors() {
        List<Person> a = this.authors;
        if (a == null) {
            Entry entry = this;
            synchronized (entry) {
                a = this.authors;
                if (a == null) {
                    this.authors = a = new ArrayList<Person>();
                }
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Category> getCategories() {
        List<Category> c = this.categories;
        if (c == null) {
            Entry entry = this;
            synchronized (entry) {
                c = this.categories;
                if (c == null) {
                    this.categories = c = new ArrayList<Category>();
                }
            }
        }
        return c;
    }

    public Content getContent() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Person> getContributors() {
        List<Person> c = this.contributors;
        if (c == null) {
            Entry entry = this;
            synchronized (entry) {
                c = this.contributors;
                if (c == null) {
                    this.contributors = c = new ArrayList<Person>();
                }
            }
        }
        return c;
    }

    public String getId() {
        return this.id;
    }

    public Link getLink(Relation rel) {
        Link result = null;
        Link current = null;
        Iterator<Link> iter = this.getLinks().iterator();
        while (result == null && iter.hasNext()) {
            current = iter.next();
            if (current.getRel() != rel) continue;
            result = current;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Link> getLinks() {
        List<Link> l = this.links;
        if (l == null) {
            Entry entry = this;
            synchronized (entry) {
                l = this.links;
                if (l == null) {
                    this.links = l = new ArrayList<Link>();
                }
            }
        }
        return l;
    }

    public Date getPublished() {
        return this.published;
    }

    public Text getRights() {
        return this.rights;
    }

    public Source getSource() {
        return this.source;
    }

    public String getSummary() {
        return this.summary;
    }

    public Text getTitle() {
        return this.title;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setPublished(Date published) {
        this.published = DateUtils.unmodifiable((Date)published);
    }

    public void setRights(Text rights) {
        this.rights = rights;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setTitle(Text title) {
        this.title = title;
    }

    public void setUpdated(Date updated) {
        this.updated = DateUtils.unmodifiable((Date)updated);
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        writer.startElement("http://www.w3.org/2005/Atom", "entry");
        if (this.getAuthors() != null) {
            for (Person person : this.getAuthors()) {
                person.writeElement(writer, "author");
            }
        }
        if (this.getCategories() != null) {
            for (Category category : this.getCategories()) {
                category.writeElement(writer);
            }
        }
        if (this.getContent() != null) {
            this.getContent().writeElement(writer);
        }
        if (this.getContributors() != null) {
            for (Person person : this.getContributors()) {
                person.writeElement(writer, "contributor");
            }
        }
        if (this.getId() != null) {
            writer.dataElement("http://www.w3.org/2005/Atom", "id", this.getId());
        }
        if (this.getLinks() != null) {
            for (Link link : this.getLinks()) {
                link.writeElement(writer);
            }
        }
        if (this.getPublished() != null) {
            Text.writeElement(writer, this.getPublished(), "http://www.w3.org/2005/Atom", "published");
        }
        if (this.getRights() != null) {
            this.getRights().writeElement(writer, "rights");
        }
        if (this.getSource() != null) {
            this.getSource().writeElement(writer);
        }
        if (this.getSummary() != null) {
            writer.dataElement("http://www.w3.org/2005/Atom", "summary", this.getSummary());
        }
        if (this.getTitle() != null) {
            this.getTitle().writeElement(writer, "title");
        }
        if (this.getUpdated() != null) {
            Text.writeElement(writer, this.getUpdated(), "http://www.w3.org/2005/Atom", "updated");
        }
        writer.endElement("http://www.w3.org/2005/Atom", "entry");
    }
}

