/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.ext.atom.Category;
import org.restlet.ext.atom.Content;
import org.restlet.ext.atom.Entry;
import org.restlet.ext.atom.Generator;
import org.restlet.ext.atom.Link;
import org.restlet.ext.atom.Person;
import org.restlet.ext.atom.Relation;
import org.restlet.ext.atom.Text;
import org.restlet.resource.Representation;
import org.restlet.resource.SaxRepresentation;
import org.restlet.resource.StringRepresentation;
import org.restlet.util.DateUtils;
import org.restlet.util.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Feed
extends SaxRepresentation {
    public static final String ATOM_NAMESPACE = "http://www.w3.org/2005/Atom";
    public static final String XHTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    private volatile List<Person> authors;
    private volatile List<Category> categories;
    private volatile List<Person> contributors;
    private List<Entry> entries;
    private volatile Generator generator;
    private volatile Reference icon;
    private volatile String id;
    private volatile List<Link> links;
    private volatile Reference logo;
    private volatile Text rights;
    private volatile Text subtitle;
    private volatile Text title;
    private volatile Date updated;

    public Feed() {
        super(MediaType.APPLICATION_ATOM_XML);
        this.authors = null;
        this.categories = null;
        this.contributors = null;
        this.generator = null;
        this.icon = null;
        this.id = null;
        this.links = null;
        this.logo = null;
        this.rights = null;
        this.subtitle = null;
        this.title = null;
        this.updated = null;
        this.entries = null;
    }

    public Feed(Representation xmlFeed) throws IOException {
        super(xmlFeed);
        this.parse(new ContentReader(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Person> getAuthors() {
        List<Person> a = this.authors;
        if (a == null) {
            Feed feed = this;
            synchronized (feed) {
                a = this.authors;
                if (a == null) {
                    this.authors = a = new ArrayList<Person>();
                }
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Category> getCategories() {
        List<Category> c = this.categories;
        if (c == null) {
            Feed feed = this;
            synchronized (feed) {
                c = this.categories;
                if (c == null) {
                    this.categories = c = new ArrayList<Category>();
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Person> getContributors() {
        List<Person> c = this.contributors;
        if (c == null) {
            Feed feed = this;
            synchronized (feed) {
                c = this.contributors;
                if (c == null) {
                    this.contributors = c = new ArrayList<Person>();
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> getEntries() {
        List<Entry> e = this.entries;
        if (e == null) {
            Feed feed = this;
            synchronized (feed) {
                e = this.entries;
                if (e == null) {
                    this.entries = e = new ArrayList<Entry>();
                }
            }
        }
        return e;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public Reference getIcon() {
        return this.icon;
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Link> getLinks() {
        List<Link> l = this.links;
        if (l == null) {
            Feed feed = this;
            synchronized (feed) {
                l = this.links;
                if (l == null) {
                    this.links = l = new ArrayList<Link>();
                }
            }
        }
        return l;
    }

    public Reference getLogo() {
        return this.logo;
    }

    public Text getRights() {
        return this.rights;
    }

    public Text getSubtitle() {
        return this.subtitle;
    }

    public Text getTitle() {
        return this.title;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }

    public void setIcon(Reference icon) {
        this.icon = icon;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLogo(Reference logo) {
        this.logo = logo;
    }

    public void setRights(Text rights) {
        this.rights = rights;
    }

    public void setSubtitle(Text subtitle) {
        this.subtitle = subtitle;
    }

    public void setTitle(Text title) {
        this.title = title;
    }

    public void setUpdated(Date updated) {
        this.updated = DateUtils.unmodifiable((Date)updated);
    }

    public void write(XmlWriter writer) throws IOException {
        try {
            writer.setPrefix(ATOM_NAMESPACE, "atom");
            writer.setDataFormat(true);
            writer.setIndentStep(3);
            writer.startDocument();
            this.writeElement(writer);
            writer.endDocument();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        writer.startElement(ATOM_NAMESPACE, "feed");
        if (this.getAuthors() != null) {
            for (Person person : this.getAuthors()) {
                person.writeElement(writer, "author");
            }
        }
        if (this.getCategories() != null) {
            for (Category category : this.getCategories()) {
                category.writeElement(writer);
            }
        }
        if (this.getContributors() != null) {
            for (Person person : this.getContributors()) {
                person.writeElement(writer, "contributor");
            }
        }
        if (this.getGenerator() != null) {
            this.getGenerator().writeElement(writer);
        }
        if (this.getIcon() != null) {
            writer.dataElement(ATOM_NAMESPACE, "icon", this.getIcon().toString());
        }
        if (this.getId() != null) {
            writer.dataElement(ATOM_NAMESPACE, "id", null, (Attributes)new AttributesImpl(), this.getId());
        }
        if (this.getLinks() != null) {
            for (Link link : this.getLinks()) {
                link.writeElement(writer);
            }
        }
        if (this.getLogo() != null && this.getLogo().toString() != null) {
            writer.dataElement(ATOM_NAMESPACE, "logo", this.getLogo().toString());
        }
        if (this.getRights() != null) {
            this.getRights().writeElement(writer, "rights");
        }
        if (this.getSubtitle() != null) {
            this.getSubtitle().writeElement(writer, "subtitle");
        }
        if (this.getTitle() != null) {
            this.getTitle().writeElement(writer, "title");
        }
        if (this.getUpdated() != null) {
            Text.writeElement(writer, this.getUpdated(), ATOM_NAMESPACE, "updated");
        }
        if (this.getEntries() != null) {
            for (Entry entry : this.getEntries()) {
                entry.writeElement(writer);
            }
        }
        writer.endElement(ATOM_NAMESPACE, "feed");
    }

    private static class ContentReader
    extends DefaultHandler {
        private StringBuilder contentBuffer;
        private Category currentCategory;
        private Content currentContent;
        private XmlWriter currentContentWriter;
        private Date currentDate;
        private Entry currentEntry;
        private final Feed currentFeed;
        private Link currentLink;
        private Person currentPerson;
        private Text currentText;
        private Map<String, String> prefixMappings;
        private State state = State.NONE;

        public ContentReader(Feed feed) {
            this.currentFeed = feed;
            this.currentEntry = null;
            this.currentText = null;
            this.currentDate = null;
            this.currentLink = null;
            this.currentPerson = null;
            this.contentBuffer = null;
            this.currentCategory = null;
            this.currentContent = null;
            this.prefixMappings = new TreeMap<String, String>();
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.state == State.FEED_ENTRY_CONTENT) {
                if (this.currentContentWriter != null) {
                    this.currentContentWriter.characters(ch, start, length);
                }
            } else {
                this.contentBuffer.append(ch, start, length);
            }
        }

        public void endDocument() throws SAXException {
            this.state = State.NONE;
            this.currentEntry = null;
            this.contentBuffer = null;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.currentText != null) {
                this.currentText.setContent(this.contentBuffer.toString());
            }
            if (this.currentDate != null) {
                String formattedDate = this.contentBuffer.toString();
                Date parsedDate = DateUtils.parse((String)formattedDate, (List)DateUtils.FORMAT_RFC_3339);
                if (parsedDate != null) {
                    this.currentDate.setTime(parsedDate.getTime());
                } else {
                    this.currentDate = null;
                }
            }
            if (uri.equalsIgnoreCase(Feed.ATOM_NAMESPACE)) {
                if (localName.equals("feed")) {
                    this.state = State.NONE;
                } else if (localName.equals("title")) {
                    if (this.state == State.FEED_TITLE) {
                        this.currentFeed.setTitle(this.currentText);
                        this.state = State.FEED;
                    } else if (this.state == State.FEED_ENTRY_TITLE) {
                        this.currentEntry.setTitle(this.currentText);
                        this.state = State.FEED_ENTRY;
                    } else if (this.state == State.FEED_ENTRY_SOURCE_TITLE) {
                        this.currentEntry.getSource().setTitle(this.currentText);
                        this.state = State.FEED_ENTRY_SOURCE;
                    }
                } else if (localName.equals("updated")) {
                    if (this.state == State.FEED_UPDATED) {
                        this.currentFeed.setUpdated(this.currentDate);
                        this.state = State.FEED;
                    } else if (this.state == State.FEED_ENTRY_UPDATED) {
                        this.currentEntry.setUpdated(this.currentDate);
                        this.state = State.FEED_ENTRY;
                    } else if (this.state == State.FEED_ENTRY_SOURCE_UPDATED) {
                        this.currentEntry.getSource().setUpdated(this.currentDate);
                        this.state = State.FEED_ENTRY_SOURCE;
                    }
                } else if (localName.equals("published")) {
                    if (this.state == State.FEED_ENTRY_PUBLISHED) {
                        this.currentEntry.setPublished(this.currentDate);
                        this.state = State.FEED_ENTRY;
                    }
                } else if (localName.equals("author")) {
                    if (this.state == State.FEED_AUTHOR) {
                        this.currentFeed.getAuthors().add(this.currentPerson);
                        this.state = State.FEED;
                    } else if (this.state == State.FEED_ENTRY_AUTHOR) {
                        this.currentEntry.getAuthors().add(this.currentPerson);
                        this.state = State.FEED_ENTRY;
                    } else if (this.state == State.FEED_ENTRY_SOURCE_AUTHOR) {
                        this.currentEntry.getSource().getAuthors().add(this.currentPerson);
                        this.state = State.FEED_ENTRY_SOURCE;
                    }
                } else if (localName.equals("name")) {
                    this.currentPerson.setName(this.contentBuffer.toString());
                    if (this.state == State.FEED_AUTHOR_NAME) {
                        this.state = State.FEED_AUTHOR;
                    } else if (this.state == State.FEED_ENTRY_AUTHOR_NAME) {
                        this.state = State.FEED_ENTRY_AUTHOR;
                    } else if (this.state == State.FEED_ENTRY_SOURCE_AUTHOR_NAME) {
                        this.state = State.FEED_ENTRY_SOURCE_AUTHOR;
                    }
                } else if (localName.equals("id")) {
                    if (this.state == State.FEED_ID) {
                        this.currentFeed.setId(this.contentBuffer.toString());
                        this.state = State.FEED;
                    } else if (this.state == State.FEED_ENTRY_ID) {
                        this.currentEntry.setId(this.contentBuffer.toString());
                        this.state = State.FEED_ENTRY;
                    } else if (this.state == State.FEED_ENTRY_SOURCE_ID) {
                        this.currentEntry.getSource().setId(this.contentBuffer.toString());
                        this.state = State.FEED_ENTRY_SOURCE;
                    }
                } else if (localName.equals("link")) {
                    if (this.state == State.FEED_LINK) {
                        this.currentFeed.getLinks().add(this.currentLink);
                        this.state = State.FEED;
                    } else if (this.state == State.FEED_ENTRY_LINK) {
                        this.currentEntry.getLinks().add(this.currentLink);
                        this.state = State.FEED_ENTRY;
                    } else if (this.state == State.FEED_ENTRY_SOURCE_LINK) {
                        this.currentEntry.getSource().getLinks().add(this.currentLink);
                        this.state = State.FEED_ENTRY_SOURCE;
                    }
                } else if (localName.equalsIgnoreCase("entry")) {
                    if (this.state == State.FEED_ENTRY) {
                        this.currentFeed.getEntries().add(this.currentEntry);
                        this.state = State.FEED;
                    }
                } else if (localName.equals("category")) {
                    if (this.state == State.FEED_CATEGORY) {
                        this.currentFeed.getCategories().add(this.currentCategory);
                        this.state = State.FEED;
                    } else if (this.state == State.FEED_ENTRY_CATEGORY) {
                        this.currentEntry.getCategories().add(this.currentCategory);
                        this.state = State.FEED_ENTRY;
                    } else if (this.state == State.FEED_ENTRY_SOURCE_CATEGORY) {
                        this.currentEntry.getSource().getCategories().add(this.currentCategory);
                        this.state = State.FEED_ENTRY_SOURCE;
                    }
                } else if (localName.equalsIgnoreCase("content") && this.state == State.FEED_ENTRY_CONTENT) {
                    if (!this.currentEntry.getContent().isExternal()) {
                        this.currentContent.setInlineContent((Representation)new StringRepresentation((CharSequence)this.currentContentWriter.getWriter().toString().trim()));
                    }
                    this.state = State.FEED_ENTRY;
                }
            } else if (this.state == State.FEED_ENTRY_CONTENT && this.currentContentWriter != null) {
                this.currentContentWriter.endElement(uri, localName, qName);
            }
            this.currentText = null;
            this.currentDate = null;
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.prefixMappings.remove(prefix);
        }

        private MediaType getMediaType(String type) {
            MediaType result = null;
            if (type != null) {
                result = type.equals("text") ? MediaType.TEXT_PLAIN : (type.equals("html") ? MediaType.TEXT_HTML : (type.equals("xhtml") ? MediaType.APPLICATION_XHTML_XML : new MediaType(type)));
            }
            return result;
        }

        public void startDocument() throws SAXException {
            this.contentBuffer = new StringBuilder();
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            this.contentBuffer.delete(0, this.contentBuffer.length() + 1);
            if (uri.equalsIgnoreCase(Feed.ATOM_NAMESPACE)) {
                if (localName.equals("feed")) {
                    this.state = State.FEED;
                } else if (localName.equals("title")) {
                    this.startTextElement(attrs);
                    if (this.state == State.FEED) {
                        this.state = State.FEED_TITLE;
                    } else if (this.state == State.FEED_ENTRY) {
                        this.state = State.FEED_ENTRY_TITLE;
                    } else if (this.state == State.FEED_ENTRY_SOURCE) {
                        this.state = State.FEED_ENTRY_SOURCE_TITLE;
                    }
                } else if (localName.equals("updated")) {
                    this.currentDate = new Date();
                    if (this.state == State.FEED) {
                        this.state = State.FEED_UPDATED;
                    } else if (this.state == State.FEED_ENTRY) {
                        this.state = State.FEED_ENTRY_UPDATED;
                    } else if (this.state == State.FEED_ENTRY_SOURCE) {
                        this.state = State.FEED_ENTRY_SOURCE_UPDATED;
                    }
                } else if (localName.equals("published")) {
                    this.currentDate = new Date();
                    if (this.state == State.FEED_ENTRY) {
                        this.state = State.FEED_ENTRY_PUBLISHED;
                    }
                } else if (localName.equals("author")) {
                    this.currentPerson = new Person();
                    if (this.state == State.FEED) {
                        this.state = State.FEED_AUTHOR;
                    } else if (this.state == State.FEED_ENTRY) {
                        this.state = State.FEED_ENTRY_AUTHOR;
                    } else if (this.state == State.FEED_ENTRY_SOURCE) {
                        this.state = State.FEED_ENTRY_SOURCE_AUTHOR;
                    }
                } else if (localName.equals("name")) {
                    if (this.state == State.FEED_AUTHOR) {
                        this.state = State.FEED_AUTHOR_NAME;
                    } else if (this.state == State.FEED_ENTRY_AUTHOR) {
                        this.state = State.FEED_ENTRY_AUTHOR_NAME;
                    } else if (this.state == State.FEED_ENTRY_SOURCE_AUTHOR) {
                        this.state = State.FEED_ENTRY_SOURCE_AUTHOR_NAME;
                    }
                } else if (localName.equals("id")) {
                    if (this.state == State.FEED) {
                        this.state = State.FEED_ID;
                    } else if (this.state == State.FEED_ENTRY) {
                        this.state = State.FEED_ENTRY_ID;
                    } else if (this.state == State.FEED_ENTRY_SOURCE) {
                        this.state = State.FEED_ENTRY_SOURCE_ID;
                    }
                } else if (localName.equals("link")) {
                    this.currentLink = new Link();
                    this.currentLink.setHref(new Reference(attrs.getValue("", "href")));
                    this.currentLink.setRel(Relation.parse(attrs.getValue("", "rel")));
                    this.currentLink.setType(new MediaType(attrs.getValue("", "type")));
                    this.currentLink.setHrefLang(new Language(attrs.getValue("", "hreflang")));
                    this.currentLink.setTitle(attrs.getValue("", "title"));
                    String attr = attrs.getValue("", "length");
                    this.currentLink.setLength(attr == null ? -1L : Long.parseLong(attr));
                    if (this.state == State.FEED) {
                        this.state = State.FEED_LINK;
                    } else if (this.state == State.FEED_ENTRY) {
                        this.state = State.FEED_ENTRY_LINK;
                    } else if (this.state == State.FEED_ENTRY_SOURCE) {
                        this.state = State.FEED_ENTRY_SOURCE_LINK;
                    }
                } else if (localName.equalsIgnoreCase("entry")) {
                    if (this.state == State.FEED) {
                        this.currentEntry = new Entry();
                        this.state = State.FEED_ENTRY;
                    }
                } else if (localName.equals("category")) {
                    this.currentCategory = new Category();
                    this.currentCategory.setTerm(attrs.getValue("", "term"));
                    this.currentCategory.setScheme(new Reference(attrs.getValue("", "scheme")));
                    this.currentCategory.setLabel(attrs.getValue("", "label"));
                    if (this.state == State.FEED) {
                        this.state = State.FEED_CATEGORY;
                    } else if (this.state == State.FEED_ENTRY) {
                        this.state = State.FEED_ENTRY_CATEGORY;
                    } else if (this.state == State.FEED_ENTRY_SOURCE) {
                        this.state = State.FEED_ENTRY_SOURCE_CATEGORY;
                    }
                } else if (localName.equalsIgnoreCase("content") && this.state == State.FEED_ENTRY) {
                    MediaType type = this.getMediaType(attrs.getValue("", "type"));
                    String srcAttr = attrs.getValue("", "src");
                    this.currentContent = new Content();
                    if (srcAttr == null) {
                        StringWriter sw = new StringWriter();
                        this.currentContentWriter = new XmlWriter((Writer)sw);
                        for (String prefix : this.prefixMappings.keySet()) {
                            this.currentContentWriter.forceNSDecl(this.prefixMappings.get(prefix), prefix);
                        }
                    } else {
                        this.currentContent.setExternalRef(new Reference(srcAttr));
                        this.currentContent.setExternalType(type);
                    }
                    this.currentEntry.setContent(this.currentContent);
                    this.state = State.FEED_ENTRY_CONTENT;
                }
            } else if (this.state == State.FEED_ENTRY_CONTENT && this.currentContentWriter != null) {
                this.currentContentWriter.startElement(uri, localName, qName, attrs);
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.prefixMappings.put(prefix, uri);
        }

        public void startTextElement(Attributes attrs) {
            this.currentText = new Text(this.getMediaType(attrs.getValue("", "type")));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum State {
            FEED,
            FEED_AUTHOR,
            FEED_AUTHOR_EMAIL,
            FEED_AUTHOR_NAME,
            FEED_AUTHOR_URI,
            FEED_CATEGORY,
            FEED_CONTRIBUTOR,
            FEED_CONTRIBUTOR_EMAIL,
            FEED_CONTRIBUTOR_NAME,
            FEED_CONTRIBUTOR_URI,
            FEED_ENTRY,
            FEED_ENTRY_AUTHOR,
            FEED_ENTRY_AUTHOR_EMAIL,
            FEED_ENTRY_AUTHOR_NAME,
            FEED_ENTRY_AUTHOR_URI,
            FEED_ENTRY_CATEGORY,
            FEED_ENTRY_CONTENT,
            FEED_ENTRY_CONTRIBUTOR,
            FEED_ENTRY_ID,
            FEED_ENTRY_LINK,
            FEED_ENTRY_PUBLISHED,
            FEED_ENTRY_RIGHTS,
            FEED_ENTRY_SOURCE,
            FEED_ENTRY_SOURCE_AUTHOR,
            FEED_ENTRY_SOURCE_AUTHOR_EMAIL,
            FEED_ENTRY_SOURCE_AUTHOR_NAME,
            FEED_ENTRY_SOURCE_AUTHOR_URI,
            FEED_ENTRY_SOURCE_CATEGORY,
            FEED_ENTRY_SOURCE_CONTRIBUTOR,
            FEED_ENTRY_SOURCE_GENERATOR,
            FEED_ENTRY_SOURCE_ICON,
            FEED_ENTRY_SOURCE_ID,
            FEED_ENTRY_SOURCE_LINK,
            FEED_ENTRY_SOURCE_LOGO,
            FEED_ENTRY_SOURCE_RIGHTS,
            FEED_ENTRY_SOURCE_SUBTITLE,
            FEED_ENTRY_SOURCE_TITLE,
            FEED_ENTRY_SOURCE_UPDATED,
            FEED_ENTRY_SUMMARY,
            FEED_ENTRY_TITLE,
            FEED_ENTRY_UPDATED,
            FEED_GENERATOR,
            FEED_ICON,
            FEED_ID,
            FEED_LINK,
            FEED_LOGO,
            FEED_RIGHTS,
            FEED_SUBTITLE,
            FEED_TITLE,
            FEED_UPDATED,
            NONE;

        }
    }
}

