/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.restlet.Client;
import org.restlet.Context;
import org.restlet.Uniform;
import org.restlet.data.MediaType;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.ext.atom.Collection;
import org.restlet.ext.atom.MemberType;
import org.restlet.ext.atom.Workspace;
import org.restlet.resource.Representation;
import org.restlet.resource.SaxRepresentation;
import org.restlet.util.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Service
extends SaxRepresentation {
    public static final String APP_NAMESPACE = "http://www.w3.org/2007/app";
    private volatile Uniform clientDispatcher;
    private volatile Reference reference;
    private volatile List<Workspace> workspaces;

    public Service(Context context, String serviceUri) throws IOException {
        this(context.getClientDispatcher(), serviceUri, context.getClientDispatcher().get(serviceUri).getEntity());
    }

    public Service(String serviceUri) throws IOException {
        this((Uniform)new Client(Protocol.HTTP), serviceUri);
    }

    public Service(String serviceUri, Representation xmlService) throws IOException {
        this((Uniform)new Client(Protocol.HTTP), serviceUri, xmlService);
    }

    public Service(Uniform clientDispatcher) {
        super(new MediaType("***"));
        this.clientDispatcher = clientDispatcher;
    }

    public Service(Uniform clientDispatcher, String serviceUri) throws IOException {
        this(clientDispatcher, serviceUri, clientDispatcher.get(serviceUri).getEntity());
    }

    public Service(Uniform clientDispatcher, String serviceUri, Representation xmlService) throws IOException {
        super(xmlService);
        this.clientDispatcher = clientDispatcher;
        this.reference = new Reference(serviceUri);
        this.parse(new ContentReader(this));
    }

    public Status deleteResource(String uri) {
        return this.getClientDispatcher().delete(uri).getStatus();
    }

    public Uniform getClientDispatcher() {
        return this.clientDispatcher;
    }

    public Reference getReference() {
        return this.reference;
    }

    public Representation getResource(String uri) {
        return this.getClientDispatcher().get(uri).getEntity();
    }

    public List<Workspace> getWorkspaces() {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList<Workspace>();
        }
        return this.workspaces;
    }

    public void setClientDispatcher(Uniform clientDispatcher) {
        this.clientDispatcher = clientDispatcher;
    }

    public void setReference(Reference ref) {
        this.reference = ref;
    }

    public Status updateResource(String uri, Representation updatedRepresentation) {
        return this.getClientDispatcher().put(uri, updatedRepresentation).getStatus();
    }

    public void write(XmlWriter writer) throws IOException {
        try {
            writer.forceNSDecl(APP_NAMESPACE, "");
            writer.forceNSDecl("http://www.w3.org/2005/Atom", "atom");
            writer.setDataFormat(true);
            writer.setIndentStep(3);
            writer.startDocument();
            writer.startElement(APP_NAMESPACE, "service");
            for (Workspace workspace : this.getWorkspaces()) {
                workspace.writeElement(writer);
            }
            writer.endElement(APP_NAMESPACE, "service");
            writer.endDocument();
        }
        catch (SAXException se) {
            throw new IOException("Couldn't write the service representation: " + se.getMessage());
        }
    }

    private class ContentReader
    extends DefaultHandler {
        private static final int IN_COLLECTION = 3;
        private static final int IN_MEMBER_TYPE = 4;
        private static final int IN_NONE = 0;
        private static final int IN_SERVICE = 1;
        private static final int IN_WORKSPACE = 2;
        private StringBuilder contentBuffer = null;
        private Collection currentCollection = null;
        private Service currentService = null;
        private Workspace currentWorkspace = null;
        private int state = 0;

        public ContentReader(Service service2) {
            this.currentService = service2;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.state == 4) {
                this.contentBuffer.append(ch, start, length);
            }
        }

        public void endDocument() throws SAXException {
            this.state = 0;
            this.currentWorkspace = null;
            this.currentCollection = null;
            this.contentBuffer = null;
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equalsIgnoreCase("service")) {
                this.state = 0;
            } else if (localName.equalsIgnoreCase("workspace")) {
                if (this.state == 2) {
                    Service.this.getWorkspaces().add(this.currentWorkspace);
                    this.currentWorkspace = null;
                    this.state = 1;
                }
            } else if (localName.equalsIgnoreCase("collection")) {
                if (this.state == 3) {
                    this.currentWorkspace.getCollections().add(this.currentCollection);
                    this.currentCollection = null;
                    this.state = 2;
                }
            } else if (localName.equalsIgnoreCase("member-type") && this.state == 4) {
                String memberType = this.contentBuffer.toString();
                if (memberType.equalsIgnoreCase("entry")) {
                    this.currentCollection.setMemberType(MemberType.ENTRY);
                } else if (memberType.equalsIgnoreCase("media")) {
                    this.currentCollection.setMemberType(MemberType.MEDIA);
                }
                this.state = 3;
            }
        }

        public void startDocument() throws SAXException {
            this.state = 0;
            this.currentWorkspace = null;
            this.currentCollection = null;
            this.contentBuffer = null;
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (uri.equalsIgnoreCase(Service.APP_NAMESPACE)) {
                if (localName.equalsIgnoreCase("service")) {
                    this.state = 1;
                } else if (localName.equalsIgnoreCase("workspace")) {
                    if (this.state == 1) {
                        this.currentWorkspace = new Workspace(this.currentService, attrs.getValue("title"));
                        this.state = 2;
                    }
                } else if (localName.equalsIgnoreCase("collection")) {
                    if (this.state == 2) {
                        this.currentCollection = new Collection(this.currentWorkspace, attrs.getValue("title"), attrs.getValue("href"));
                        this.state = 3;
                    }
                } else if (localName.equalsIgnoreCase("member-type") && this.state == 3) {
                    this.contentBuffer = new StringBuilder();
                    this.state = 4;
                }
            }
        }
    }
}

