/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.restlet.data.MediaType;
import org.restlet.util.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Text {
    private volatile String content;
    private volatile MediaType type;

    public static void writeElement(XmlWriter writer, Date date, String namespace, String localName) throws SAXException {
        writer.startElement(namespace, localName);
        if (date != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            writer.characters(dateFormat.format(date));
        }
        writer.endElement(namespace, localName);
    }

    public Text(MediaType type) {
        this(type, null);
    }

    public Text(MediaType type, String content) {
        this.type = type;
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    public MediaType getType() {
        return this.type;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setType(MediaType type) {
        this.type = type;
    }

    public void writeElement(XmlWriter writer, String localName) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        String type = null;
        if (this.getType() != null && this.getType().getSubType() != null) {
            if (this.getType().getSubType().contains("xhtml")) {
                type = "xhtml";
            } else if (this.getType().getSubType().contains("html")) {
                type = "html";
            }
        }
        if (type == null) {
            type = "text";
        }
        attributes.addAttribute("", "type", null, "text", type);
        if (this.getContent() != null) {
            writer.dataElement("http://www.w3.org/2005/Atom", localName, null, (Attributes)attributes, this.getContent());
        } else {
            writer.emptyElement("http://www.w3.org/2005/Atom", localName, null, (Attributes)attributes);
        }
    }
}

