/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import org.eclipse.aether.artifact.Artifact;
import org.revapi.Archive;

class MavenArchive
implements Archive.Versioned {
    private final File file;
    private final String gav;
    private final String version;

    private MavenArchive(Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("Artifact cannot be null");
        }
        this.file = artifact.getFile();
        if (this.file == null) {
            throw new IllegalArgumentException("Could not locate the file of the maven artifact: " + artifact);
        }
        this.gav = artifact.toString();
        this.version = artifact.getBaseVersion();
    }

    public static MavenArchive of(Artifact artifact) {
        switch (artifact.getExtension()) {
            case "war": {
                return new War(artifact);
            }
            case "ear": {
                return new Empty(artifact);
            }
            case "pom": {
                return new Empty(artifact);
            }
        }
        return new Jar(artifact);
    }

    @Nonnull
    public String getName() {
        return this.gav;
    }

    @Nonnull
    public InputStream openStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArchive that = (MavenArchive)o;
        return this.file.equals(that.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return "MavenArchive[gav=" + this.gav + ", file=" + this.file + ']';
    }

    public static final class Empty
    extends MavenArchive {
        public Empty(Artifact artifact) {
            super(artifact);
        }

        @Override
        @Nonnull
        public InputStream openStream() throws IOException {
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }
            };
        }
    }

    public static final class War
    extends MavenArchive {
        public War(Artifact artifact) {
            super(artifact);
        }

        @Override
        @Nonnull
        public InputStream openStream() throws IOException {
            final Path path = Files.createTempFile("revapi-maven-plugin", null, new FileAttribute[0]);
            try (ZipInputStream warZip = new ZipInputStream(super.openStream());
                 ZipOutputStream croppedZip = new ZipOutputStream(new FileOutputStream(path.toFile()));){
                croppedZip.setLevel(0);
                croppedZip.setMethod(8);
                byte[] buf = new byte[32768];
                ZipEntry inEntry = warZip.getNextEntry();
                int prefixLen = "WEB-INF/classes/".length();
                while (inEntry != null) {
                    if (inEntry.getName().startsWith("WEB-INF/classes/") && inEntry.getName().length() > prefixLen) {
                        ZipEntry outEntry = new ZipEntry(inEntry.getName().substring(prefixLen));
                        croppedZip.putNextEntry(outEntry);
                        if (!inEntry.isDirectory()) {
                            int cnt;
                            while ((cnt = warZip.read(buf)) != -1) {
                                croppedZip.write(buf, 0, cnt);
                            }
                        }
                        croppedZip.closeEntry();
                    }
                    inEntry = warZip.getNextEntry();
                }
            }
            return new FileInputStream(path.toFile()){

                @Override
                public void close() throws IOException {
                    super.close();
                    Files.delete(path);
                }
            };
        }
    }

    public static final class Jar
    extends MavenArchive {
        public Jar(Artifact artifact) {
            super(artifact);
        }
    }
}

