/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.servlet;

import freemarker.cache.WebappTemplateLoader;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.AllHttpScopesHashModel;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.HttpRequestParametersHashModel;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class FreemarkerServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger("freemarker.servlet");
    public static final long serialVersionUID = -2440216393145762479L;
    private static final String INITPARAM_TEMPLATE_PATH = "TemplatePath";
    private static final String INITPARAM_NOCACHE = "NoCache";
    private static final String INITPARAM_CONTENT_TYPE = "ContentType";
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private static final String INITPARAM_DEBUG = "Debug";
    private static final String DEPR_INITPARAM_TEMPLATE_DELAY = "TemplateDelay";
    private static final String DEPR_INITPARAM_ENCODING = "DefaultEncoding";
    private static final String DEPR_INITPARAM_OBJECT_WRAPPER = "ObjectWrapper";
    private static final String DEPR_INITPARAM_WRAPPER_SIMPLE = "simple";
    private static final String DEPR_INITPARAM_WRAPPER_BEANS = "beans";
    private static final String DEPR_INITPARAM_WRAPPER_JYTHON = "jython";
    private static final String DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER = "TemplateExceptionHandler";
    private static final String DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER_RETHROW = "rethrow";
    private static final String DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER_DEBUG = "debug";
    private static final String DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER_HTML_DEBUG = "htmlDebug";
    private static final String DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER_IGNORE = "ignore";
    private static final String DEPR_INITPARAM_DEBUG = "debug";
    public static final String KEY_REQUEST = "Request";
    public static final String KEY_REQUEST_PRIVATE = "__FreeMarkerServlet.Request__";
    public static final String KEY_REQUEST_PARAMETERS = "RequestParameters";
    public static final String KEY_SESSION = "Session";
    public static final String KEY_APPLICATION = "Application";
    public static final String KEY_APPLICATION_PRIVATE = "__FreeMarkerServlet.Application__";
    public static final String KEY_JSP_TAGLIBS = "JspTaglibs";
    private static final String ATTR_REQUEST_MODEL = ".freemarker.Request";
    private static final String ATTR_REQUEST_PARAMETERS_MODEL = ".freemarker.RequestParameters";
    private static final String ATTR_SESSION_MODEL = ".freemarker.Session";
    private static final String ATTR_APPLICATION_MODEL = ".freemarker.Application";
    private static final String ATTR_JSP_TAGLIBS_MODEL = ".freemarker.JspTaglibs";
    private static final String EXPIRATION_DATE;
    private String templatePath;
    private boolean nocache;
    protected boolean debug;
    private Configuration config;
    private ObjectWrapper wrapper;
    private String contentType;
    private boolean noCharsetInContentType;
    static /* synthetic */ Class class$java$lang$Throwable;

    public void init() throws ServletException {
        try {
            this.config = this.createConfiguration();
            this.config.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
            this.contentType = DEFAULT_CONTENT_TYPE;
            this.wrapper = this.createObjectWrapper();
            if (logger.isDebugEnabled()) {
                logger.debug("Using object wrapper of class " + this.wrapper.getClass().getName());
            }
            this.config.setObjectWrapper(this.wrapper);
            this.templatePath = this.getInitParameter(INITPARAM_TEMPLATE_PATH);
            if (this.templatePath == null) {
                this.templatePath = "class://";
            }
            if (this.templatePath.startsWith("class://")) {
                this.config.setClassForTemplateLoading(this.getClass(), this.templatePath.substring(7));
            } else if (this.templatePath.startsWith("file://")) {
                this.templatePath = this.templatePath.substring(7);
                this.config.setDirectoryForTemplateLoading(new File(this.templatePath));
            } else {
                this.config.setTemplateLoader(new WebappTemplateLoader(this.getServletContext(), this.templatePath));
            }
            Enumeration initpnames = this.getServletConfig().getInitParameterNames();
            while (initpnames.hasMoreElements()) {
                String name = (String)initpnames.nextElement();
                String value = this.getInitParameter(name);
                if (name == null) {
                    throw new ServletException("init-param without param-name. Maybe the web.xml is not well-formed?");
                }
                if (value == null) {
                    throw new ServletException("init-param without param-value. Maybe the web.xml is not well-formed?");
                }
                if (name.equals(DEPR_INITPARAM_OBJECT_WRAPPER) || name.equals("object_wrapper") || name.equals(INITPARAM_TEMPLATE_PATH)) continue;
                if (name.equals(DEPR_INITPARAM_ENCODING)) {
                    if (this.getInitParameter("default_encoding") != null) {
                        throw new ServletException("Conflicting init-params: default_encoding and DefaultEncoding");
                    }
                    this.config.setDefaultEncoding(value);
                    continue;
                }
                if (name.equals(DEPR_INITPARAM_TEMPLATE_DELAY)) {
                    if (this.getInitParameter("template_update_delay") != null) {
                        throw new ServletException("Conflicting init-params: template_update_delay and TemplateDelay");
                    }
                    try {
                        this.config.setTemplateUpdateDelay(Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (name.equals(DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER)) {
                    if (this.getInitParameter("template_exception_handler") != null) {
                        throw new ServletException("Conflicting init-params: template_exception_handler and TemplateExceptionHandler");
                    }
                    if (DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER_RETHROW.equals(value)) {
                        this.config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
                        continue;
                    }
                    if ("debug".equals(value)) {
                        this.config.setTemplateExceptionHandler(TemplateExceptionHandler.DEBUG_HANDLER);
                        continue;
                    }
                    if (DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER_HTML_DEBUG.equals(value)) {
                        this.config.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
                        continue;
                    }
                    if (DEPR_INITPARAM_TEMPLATE_EXCEPTION_HANDLER_IGNORE.equals(value)) {
                        this.config.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
                        continue;
                    }
                    throw new ServletException("Invalid value for servlet init-param TemplateExceptionHandler: " + value);
                }
                if (name.equals(INITPARAM_NOCACHE)) {
                    this.nocache = StringUtil.getYesNo(value);
                    continue;
                }
                if (name.equals("debug")) {
                    if (this.getInitParameter(INITPARAM_DEBUG) != null) {
                        throw new ServletException("Conflicting init-params: Debug and debug");
                    }
                    this.debug = StringUtil.getYesNo(value);
                    continue;
                }
                if (name.equals(INITPARAM_DEBUG)) {
                    this.debug = StringUtil.getYesNo(value);
                    continue;
                }
                if (name.equals(INITPARAM_CONTENT_TYPE)) {
                    this.contentType = value;
                    continue;
                }
                this.config.setSetting(name, value);
            }
            this.noCharsetInContentType = true;
            int i = this.contentType.toLowerCase().indexOf("charset=");
            if (i != -1) {
                char c = ' ';
                --i;
                while (i >= 0 && Character.isWhitespace(c = (char)this.contentType.charAt(i))) {
                    --i;
                }
                if (i == -1 || c == ';') {
                    this.noCharsetInContentType = false;
                }
            }
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block16: {
            if (this.preprocessRequest(request, response)) {
                return;
            }
            String path = this.requestUrlToTemplatePath(request);
            if (this.debug) {
                this.log("Requested template: " + path);
            }
            Template template = null;
            try {
                template = this.config.getTemplate(path, this.deduceLocale(path, request, response));
            }
            catch (FileNotFoundException e) {
                response.sendError(404);
                return;
            }
            Object attrContentType = template.getCustomAttribute("content_type");
            if (attrContentType != null) {
                response.setContentType(attrContentType.toString());
            } else if (this.noCharsetInContentType) {
                response.setContentType(this.contentType + "; charset=" + template.getEncoding());
            } else {
                response.setContentType(this.contentType);
            }
            this.setBrowserCachingPolicy(response);
            ServletContext servletContext = this.getServletContext();
            try {
                TemplateModel model = this.createModel(this.wrapper, servletContext, request, response);
                if (!this.preTemplateProcess(request, response, template, model)) break block16;
                try {
                    template.process(model, response.getWriter());
                }
                finally {
                    this.postTemplateProcess(request, response, template, model);
                }
            }
            catch (TemplateException te) {
                if (this.config.getTemplateExceptionHandler().getClass().getName().indexOf(INITPARAM_DEBUG) != -1) {
                    this.log("Error executing FreeMarker template", te);
                }
                ServletException e = new ServletException("Error executing FreeMarker template", te);
                try {
                    e.getClass().getMethod("initCause", class$java$lang$Throwable == null ? (class$java$lang$Throwable = FreemarkerServlet.class$("java.lang.Throwable")) : class$java$lang$Throwable).invoke((Object)e, te);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    protected Locale deduceLocale(String templatePath, HttpServletRequest request, HttpServletResponse response) {
        return this.config.getLocale();
    }

    protected TemplateModel createModel(ObjectWrapper wrapper, ServletContext servletContext, HttpServletRequest request, HttpServletResponse response) throws TemplateModelException {
        try {
            HttpSessionHashModel sessionModel;
            AllHttpScopesHashModel params = new AllHttpScopesHashModel(wrapper, servletContext, request);
            ServletContextHashModel servletContextModel = (ServletContextHashModel)servletContext.getAttribute(ATTR_APPLICATION_MODEL);
            if (servletContextModel == null) {
                servletContextModel = new ServletContextHashModel(this, wrapper);
                servletContext.setAttribute(ATTR_APPLICATION_MODEL, servletContextModel);
                TaglibFactory taglibs = new TaglibFactory(servletContext);
                servletContext.setAttribute(ATTR_JSP_TAGLIBS_MODEL, taglibs);
                this.initializeServletContext(request, response);
            }
            params.putUnlistedModel(KEY_APPLICATION, servletContextModel);
            params.putUnlistedModel(KEY_APPLICATION_PRIVATE, servletContextModel);
            params.putUnlistedModel(KEY_JSP_TAGLIBS, (TemplateModel)servletContext.getAttribute(ATTR_JSP_TAGLIBS_MODEL));
            HttpSession session = request.getSession(false);
            if (session != null) {
                sessionModel = (HttpSessionHashModel)session.getAttribute(ATTR_SESSION_MODEL);
                if (sessionModel == null || sessionModel.isZombie()) {
                    sessionModel = new HttpSessionHashModel(session, wrapper);
                    session.setAttribute(ATTR_SESSION_MODEL, sessionModel);
                    if (!sessionModel.isZombie()) {
                        this.initializeSession(request, response);
                    }
                }
            } else {
                sessionModel = new HttpSessionHashModel(this, request, response, wrapper);
            }
            params.putUnlistedModel(KEY_SESSION, sessionModel);
            HttpRequestHashModel requestModel = (HttpRequestHashModel)request.getAttribute(ATTR_REQUEST_MODEL);
            if (requestModel == null || requestModel.getRequest() != request) {
                requestModel = new HttpRequestHashModel(request, response, wrapper);
                request.setAttribute(ATTR_REQUEST_MODEL, requestModel);
                request.setAttribute(ATTR_REQUEST_PARAMETERS_MODEL, this.createRequestParametersHashModel(request));
            }
            params.putUnlistedModel(KEY_REQUEST, requestModel);
            params.putUnlistedModel(KEY_REQUEST_PRIVATE, requestModel);
            HttpRequestParametersHashModel requestParametersModel = (HttpRequestParametersHashModel)request.getAttribute(ATTR_REQUEST_PARAMETERS_MODEL);
            params.putUnlistedModel(KEY_REQUEST_PARAMETERS, requestParametersModel);
            return params;
        }
        catch (ServletException e) {
            throw new TemplateModelException(e);
        }
        catch (IOException e) {
            throw new TemplateModelException(e);
        }
    }

    protected String requestUrlToTemplatePath(HttpServletRequest request) {
        String includeServletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (includeServletPath != null) {
            String includePathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            return includePathInfo == null ? includeServletPath : includePathInfo;
        }
        String path = request.getPathInfo();
        if (path != null) {
            return path;
        }
        path = request.getServletPath();
        if (path != null) {
            return path;
        }
        return "";
    }

    protected boolean preprocessRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        return false;
    }

    protected Configuration createConfiguration() {
        return new Configuration();
    }

    protected ObjectWrapper createObjectWrapper() {
        String wrapper = this.getServletConfig().getInitParameter(DEPR_INITPARAM_OBJECT_WRAPPER);
        if (wrapper != null) {
            if (this.getInitParameter("object_wrapper") != null) {
                throw new RuntimeException("Conflicting init-params: object_wrapper and ObjectWrapper");
            }
            if (DEPR_INITPARAM_WRAPPER_BEANS.equals(wrapper)) {
                return ObjectWrapper.BEANS_WRAPPER;
            }
            if (DEPR_INITPARAM_WRAPPER_SIMPLE.equals(wrapper)) {
                return ObjectWrapper.SIMPLE_WRAPPER;
            }
            if (DEPR_INITPARAM_WRAPPER_JYTHON.equals(wrapper)) {
                try {
                    return (ObjectWrapper)Class.forName("freemarker.ext.jython.JythonWrapper").newInstance();
                }
                catch (InstantiationException e) {
                    throw new InstantiationError(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new IllegalAccessError(e.getMessage());
                }
                catch (ClassNotFoundException e) {
                    throw new NoClassDefFoundError(e.getMessage());
                }
            }
            return ObjectWrapper.DEFAULT_WRAPPER;
        }
        wrapper = this.getInitParameter("object_wrapper");
        if (wrapper == null) {
            return ObjectWrapper.DEFAULT_WRAPPER;
        }
        try {
            this.config.setSetting("object_wrapper", wrapper);
        }
        catch (TemplateException e) {
            throw new RuntimeException(e.toString());
        }
        return this.config.getObjectWrapper();
    }

    protected ObjectWrapper getObjectWrapper() {
        return this.wrapper;
    }

    protected final String getTemplatePath() {
        return this.templatePath;
    }

    protected HttpRequestParametersHashModel createRequestParametersHashModel(HttpServletRequest request) {
        return new HttpRequestParametersHashModel(request);
    }

    protected void initializeServletContext(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void initializeSession(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected boolean preTemplateProcess(HttpServletRequest request, HttpServletResponse response, Template template, TemplateModel data) throws ServletException, IOException {
        return true;
    }

    protected void postTemplateProcess(HttpServletRequest request, HttpServletResponse response, Template template, TemplateModel data) throws ServletException, IOException {
    }

    protected Configuration getConfiguration() {
        return this.config;
    }

    private void setBrowserCachingPolicy(HttpServletResponse res) {
        if (this.nocache) {
            res.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, post-check=0, pre-check=0");
            res.setHeader("Pragma", "no-cache");
            res.setHeader("Expires", EXPIRATION_DATE);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        GregorianCalendar expiration = new GregorianCalendar();
        expiration.roll(1, -1);
        SimpleDateFormat httpDate = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        EXPIRATION_DATE = httpDate.format(expiration.getTime());
    }
}

