/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.modules.plugins.jbossas7.BaseComponent;

public class ConnectorDiscoveryGroupValidatorComponent
extends BaseComponent<ResourceComponent<?>> {
    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration resourceConfiguration = report.getConfiguration();
        ResourceType resourceType = this.context.getResourceType();
        int configuredItemsFound = 0;
        String errorMessage = "";
        if (resourceType.getName().equals("Connection Factory") || resourceType.getName().equals("Pooled Connection Factory")) {
            String name;
            PropertyMap connector = resourceConfiguration.getMap("connector:collapsed");
            if (connector != null && !(name = connector.getSimpleValue("name:0", "")).isEmpty()) {
                ++configuredItemsFound;
            }
            errorMessage = "You need to provide either a connector name OR a discovery-group-name. ";
        } else if (resourceType.getName().equals("Bridge") || resourceType.getName().equals("Cluster Connection")) {
            PropertyList staticConnectors = resourceConfiguration.getList("static-connectors:nullable");
            if (staticConnectors != null && !staticConnectors.getList().isEmpty()) {
                ++configuredItemsFound;
            }
            errorMessage = "You need to provide either static connectors name OR a discovery-group-name. ";
        }
        String discoveryGroup = resourceConfiguration.getSimpleValue("discovery-group-name", "");
        if (!discoveryGroup.isEmpty()) {
            ++configuredItemsFound;
        }
        if (configuredItemsFound != 1) {
            errorMessage = errorMessage + (configuredItemsFound == 0 ? "You provided none." : "You provided both.");
            report.setErrorMessage(errorMessage);
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
        } else {
            super.updateResourceConfiguration(report);
        }
    }
}

