/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.modules.plugins.jbossas7.BaseComponent;

public class JVMDefinitionComponent
extends BaseComponent<JVMDefinitionComponent>
implements CreateChildResourceFacet {
    private static final String BASE_DEFINITION = "baseDefinition";

    @Override
    public CreateResourceReport createResource(CreateResourceReport report) {
        Configuration configuration = report.getResourceConfiguration();
        PropertySimple baseDefinitionProp = configuration.getSimple(BASE_DEFINITION);
        if (baseDefinitionProp != null) {
            configuration.remove(BASE_DEFINITION);
            String baseDefinitionName = baseDefinitionProp.getStringValue();
            report.setUserSpecifiedResourceName(baseDefinitionName);
            report = super.createResource(report);
        } else {
            report.setStatus(CreateResourceStatus.INVALID_CONFIGURATION);
            report.setErrorMessage("No base definition given that we can use");
        }
        return report;
    }

    @Override
    public Configuration loadResourceConfiguration() throws Exception {
        Configuration configuration = super.loadResourceConfiguration();
        String baseDefinitionName = this.path.substring(this.path.lastIndexOf(61) + 1);
        PropertySimple propertySimple = new PropertySimple(BASE_DEFINITION, (Object)baseDefinitionName);
        configuration.put((Property)propertySimple);
        return configuration;
    }
}

