/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.BaseServerComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class StandaloneASComponent<T extends ResourceComponent<?>>
extends BaseServerComponent<T>
implements MeasurementFacet,
OperationFacet {
    private static final String SERVER_CONFIG_TRAIT = "config-file";
    private static final Address ENVIRONMENT_ADDRESS = new Address("core-service=server-environment");

    @Override
    protected AS7Mode getMode() {
        return AS7Mode.STANDALONE;
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        HashSet<MeasurementScheduleRequest> leftovers = new HashSet<MeasurementScheduleRequest>(requests.size());
        for (MeasurementScheduleRequest request : requests) {
            String requestName = request.getName();
            if (requestName.equals(SERVER_CONFIG_TRAIT)) {
                this.collectConfigTrait(report, request);
                continue;
            }
            if (requestName.equals("multicastAddress")) {
                this.collectMulticastAddressTrait(report, request);
                continue;
            }
            if (requestName.equals("deployDir")) {
                this.resolveDeployDir(report, request);
                continue;
            }
            leftovers.add(request);
        }
        super.getValues(report, leftovers);
    }

    private void resolveDeployDir(MeasurementReport report, MeasurementScheduleRequest request) {
        if ("JDG".equals(this.pluginConfiguration.getSimpleValue("productType", "AS7"))) {
            this.log.debug((Object)"This is a JDG server, so there is no deployDir");
            MeasurementDataTrait trait = new MeasurementDataTrait(request, "- not applicable to JDG -");
            report.addData(trait);
            return;
        }
        Address scanner = new Address("subsystem=deployment-scanner,scanner=default");
        ReadResource op = new ReadResource(scanner);
        Result res = this.getASConnection().execute(op);
        if (res.isSuccess()) {
            Map scannerMap = (Map)res.getResult();
            String path = (String)scannerMap.get("path");
            String relativeTo = (String)scannerMap.get("relative-to");
            File basePath = this.resolveRelativePath(relativeTo);
            String deployDir = new File(basePath, path).getAbsolutePath();
            MeasurementDataTrait trait = new MeasurementDataTrait(request, deployDir);
            report.addData(trait);
        } else {
            this.log.error((Object)"No default deployment scanner was found, returning no value");
        }
    }

    private File resolveRelativePath(String relativeTo) {
        Address addr = new Address("path", relativeTo);
        ReadResource op = new ReadResource(addr);
        Result res = this.getASConnection().execute(op);
        if (res.isSuccess()) {
            Map pathMap = (Map)res.getResult();
            String path = (String)pathMap.get("path");
            String relativeToProp = (String)pathMap.get("relative-to");
            if (relativeToProp == null) {
                return new File(path);
            }
            File basePath = this.resolveRelativePath(relativeToProp);
            return new File(basePath, path);
        }
        this.log.warn((Object)("The requested path property " + relativeTo + " is not registered in the server, so not resolving it."));
        return new File(relativeTo);
    }

    @Override
    protected Address getServerAddress() {
        return this.getAddress();
    }

    @Override
    protected String getSocketBindingGroup() {
        return "standard-sockets";
    }

    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        if (name.equals("start")) {
            return this.startServer();
        }
        if (name.equals("restart")) {
            return this.restartServer(parameters);
        }
        if (name.equals("installRhqUser")) {
            return this.installManagementUser(parameters, this.pluginConfiguration);
        }
        Operation op = new Operation(name, new Address());
        Result res = this.getASConnection().execute(op);
        OperationResult operationResult = this.postProcessResult(name, res);
        if (name.equals("shutdown")) {
            if (this.waitUntilDown()) {
                operationResult.setSimpleResult("Success");
            } else {
                operationResult.setErrorMessage("Was not able to shut down the server.");
            }
        }
        if (name.equals("reload")) {
            if (this.waitUntilReloaded()) {
                operationResult.setSimpleResult("Success");
            } else {
                operationResult.setErrorMessage("Was not able to reload the server.");
            }
        }
        this.context.getAvailabilityContext().requestAvailabilityCheck();
        return operationResult;
    }

    private boolean waitUntilReloaded() {
        boolean reloaded = false;
        int count = 0;
        while (!reloaded) {
            ReadAttribute op = new ReadAttribute(new Address(), "release-version");
            try {
                Result res = this.getASConnection().execute(op);
                if (res.isSuccess() && !res.isReloadRequired()) {
                    reloaded = true;
                } else if (count > 20) {
                    break;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!reloaded) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            ++count;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("waitUntilReloaded: Used " + count + " delay round(s) to reload. Reload=" + reloaded));
        }
        return reloaded;
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration config = report.getConfiguration();
        PropertyList propertyList = config.getList("*3");
        for (Property property : propertyList.getList()) {
            PropertyMap map = (PropertyMap)property;
            String ro = map.getSimpleValue("read-only", "false");
            if (!Boolean.parseBoolean(ro)) continue;
            map.setErrorMessage("__logicalRemoved");
        }
        super.updateResourceConfiguration(report);
    }

    @Override
    @NotNull
    protected Address getEnvironmentAddress() {
        return ENVIRONMENT_ADDRESS;
    }

    @Override
    @NotNull
    protected Address getHostAddress() {
        return this.getAddress();
    }

    @Override
    @NotNull
    protected String getBaseDirAttributeName() {
        return "base-dir";
    }
}

