/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.HashSet;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class WebConnectorComponent
extends BaseComponent<WebConnectorComponent>
implements MeasurementFacet {
    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        HashSet<MeasurementScheduleRequest> leftovers = new HashSet<MeasurementScheduleRequest>(metrics.size());
        for (MeasurementScheduleRequest request : metrics) {
            if (request.getName().equals("_maxConnections")) {
                Object o;
                ReadAttribute op = new ReadAttribute(this.getAddress(), "max-connections");
                Result res = this.getASConnection().execute(op);
                int val = res.isSuccess() && res.getResult() != null ? ((o = res.getResult()) instanceof String ? Integer.valueOf((String)o).intValue() : ((Integer)o).intValue()) : this.computeMaxConnections();
                MeasurementDataNumeric data = new MeasurementDataNumeric(request, Double.valueOf(val));
                report.addData(data);
                continue;
            }
            leftovers.add(request);
        }
        super.getValues(report, leftovers);
    }

    @Override
    public Configuration loadResourceConfiguration() throws Exception {
        Configuration configuration = super.loadResourceConfiguration();
        PropertySimple maxConnProp = configuration.getSimple("max-connections");
        if (maxConnProp.getStringValue() == null) {
            int val = this.computeMaxConnections();
            maxConnProp.setIntegerValue(Integer.valueOf(val));
        }
        return configuration;
    }

    private int computeMaxConnections() {
        int val = -1;
        String scheme = null;
        ReadAttribute op = new ReadAttribute(this.getAddress(), "scheme");
        Result res = this.getASConnection().execute(op);
        if (res.isSuccess()) {
            scheme = (String)res.getResult();
        }
        Address address1 = new Address(this.getAddress());
        address1 = address1.getParent();
        address1 = address1.getParent();
        address1.add("core-service", "platform-mbean");
        address1.add("type", "operating-system");
        op = new ReadAttribute(address1, "available-processors");
        res = this.getASConnection().execute(op);
        int cores = 1;
        if (res.isSuccess() && res.getResult() != null) {
            cores = (Integer)res.getResult();
        }
        if ("http".equals(scheme)) {
            val = cores * 512;
        } else if ("https".equals(scheme)) {
            val = cores * 512;
        } else if ("ajp".equals(scheme)) {
            val = 32 * cores;
        }
        return val;
    }
}

