/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.optimizer;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.faces.application.Resource;
import org.richfaces.application.Module;
import org.richfaces.application.ServiceTracker;
import org.richfaces.application.ServicesFactoryImpl;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.ResourceFactory;
import org.richfaces.resource.ResourceFactoryImpl;
import org.richfaces.resource.ResourceKey;
import org.richfaces.resource.optimizer.Faces;
import org.richfaces.resource.optimizer.FileNameMapping;
import org.richfaces.resource.optimizer.ResourceLibraryExpander;
import org.richfaces.resource.optimizer.concurrent.CountingExecutorCompletionService;
import org.richfaces.resource.optimizer.faces.FacesImpl;
import org.richfaces.resource.optimizer.faces.ServiceFactoryModule;
import org.richfaces.resource.optimizer.naming.FileNameMapperImpl;
import org.richfaces.resource.optimizer.resource.handler.impl.DynamicResourceHandler;
import org.richfaces.resource.optimizer.resource.handler.impl.StaticResourceHandler;
import org.richfaces.resource.optimizer.resource.scan.impl.DynamicResourcesScanner;
import org.richfaces.resource.optimizer.resource.scan.impl.ResourceOrderingScanner;
import org.richfaces.resource.optimizer.resource.scan.impl.StaticResourcesScanner;
import org.richfaces.resource.optimizer.resource.util.ResourceConstants;
import org.richfaces.resource.optimizer.resource.util.ResourceUtil;
import org.richfaces.resource.optimizer.resource.writer.ResourceProcessor;
import org.richfaces.resource.optimizer.resource.writer.impl.CSSCompressingProcessor;
import org.richfaces.resource.optimizer.resource.writer.impl.CSSPackagingProcessor;
import org.richfaces.resource.optimizer.resource.writer.impl.JavaScriptCompressingProcessor;
import org.richfaces.resource.optimizer.resource.writer.impl.JavaScriptPackagingProcessor;
import org.richfaces.resource.optimizer.resource.writer.impl.ResourceWriterImpl;
import org.richfaces.resource.optimizer.strings.Constants;
import org.richfaces.resource.optimizer.task.ResourceTaskFactoryImpl;
import org.richfaces.resource.optimizer.util.MorePredicates;
import org.richfaces.resource.optimizer.vfs.VFS;
import org.richfaces.resource.optimizer.vfs.VFSRoot;
import org.richfaces.resource.optimizer.vfs.VirtualFile;

@Parameters(resourceBundle="resource-optimizer-cmdln-usage")
public class ResourceGenerator {
    private static final Logger log = RichfacesLogger.RESOURCE.getLogger();
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];
    private static final Function<String, Predicate<CharSequence>> REGEX_CONTAINS_BUILDER_FUNCTION = new Function<String, Predicate<CharSequence>>(){

        public Predicate<CharSequence> apply(String from) {
            Predicate containsPredicate = Predicates.containsPattern((String)from);
            return Predicates.and((Predicate)Predicates.notNull(), (Predicate)containsPredicate);
        }
    };
    private static final Function<Resource, String> CONTENT_TYPE_FUNCTION = new Function<Resource, String>(){

        public String apply(Resource from) {
            return from.getContentType();
        }
    };
    private static final Function<Resource, String> RESOURCE_QUALIFIER_FUNCTION = new Function<Resource, String>(){

        public String apply(Resource from) {
            return ResourceUtil.getResourceQualifier(from);
        }
    };
    private final Function<String, URL> filePathToURL = new Function<String, URL>(){

        public URL apply(String from) {
            try {
                File file = new File(from);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
            }
            catch (MalformedURLException e) {
                log.error("Bad URL in classpath", e);
            }
            return null;
        }
    };
    @Parameter(names={"--help"}, descriptionKey="help")
    private boolean help = false;
    @Parameter(names={"-o", "--output"}, descriptionKey="resourcesOutputDir", required=true)
    private String resourcesOutputDir;
    @Parameter(names={"-p", "--prefix"}, descriptionKey="staticResourcePrefix", required=true)
    private String staticResourcePrefix;
    @Parameter(names={"-m", "--mapping"}, descriptionKey="staticResourceMappingFile", required=true)
    private String staticResourceMappingFile;
    @Parameter(names={"-s", "--skins"}, descriptionKey="skins", required=true)
    private String skins;
    @Parameter(names={"-c", "--classpathDir"}, descriptionKey="classpathDir", required=true)
    private File classpathDir;
    @Parameter(names={"--includeContentType"}, descriptionKey="includedContentTypes")
    private List<String> includedContentTypes = Arrays.asList("application/javascript", "text/css", "image/.+");
    @Parameter(names={"--excludeContentType"}, descriptionKey="excludedContentTypes")
    private List<String> excludedContentTypes = Arrays.asList(new String[0]);
    @Parameter(names={"--includeFile"}, descriptionKey="includedFiles")
    private List<String> includedFiles = Arrays.asList(new String[0]);
    @Parameter(names={"--excludeFile"}, descriptionKey="excludedFiles")
    private List<String> excludedFiles = Arrays.asList("^javax.faces", "^\\Qorg.richfaces.renderkit.html.images.\\E.*", "^\\Qorg.richfaces.renderkit.html.iconimages.\\E.*");
    @Parameter(names={"--compress"}, descriptionKey="compress")
    private boolean compress = false;
    @Parameter(names={"--pack"}, descriptionKey="pack")
    private String pack;
    private FileNameMapping[] fileNameMappings = new FileNameMapping[]{new FileNameMapping("^.*showcase.*/([^/]+\\.css)$", "org.richfaces.showcase.css/$1"), new FileNameMapping("^.+/([^/]+\\.(png|gif|jpg))$", "org.richfaces.images/$1"), new FileNameMapping("^.+/([^/]+\\.css)$", "org.richfaces.css/$1")};
    private String webRoot = new File("./src/main/webapp").getAbsolutePath();
    private String encoding = "UTF-8";
    private Collection<ResourceKey> foundResources = Sets.newHashSet();
    private Ordering<ResourceKey> resourceOrdering;
    private Set<ResourceKey> resourcesWithKnownOrder;

    private ExecutorService createExecutorService() {
        int poolSize = this.pack != null ? 1 : Runtime.getRuntime().availableProcessors();
        return Executors.newFixedThreadPool(poolSize);
    }

    private Collection<ResourceProcessor> getDefaultResourceProcessors() {
        Charset charset = Charset.defaultCharset();
        if (!Strings.isNullOrEmpty((String)this.encoding)) {
            charset = Charset.forName(this.encoding);
        } else {
            log.warn("Encoding is not set explicitly, CDK resources plugin will use default platform encoding for processing char-based resources");
        }
        if (this.compress) {
            return Arrays.asList(new JavaScriptCompressingProcessor(charset, log), new CSSCompressingProcessor(charset));
        }
        return Arrays.asList(new JavaScriptPackagingProcessor(charset), new CSSPackagingProcessor(charset));
    }

    private Predicate<Resource> createResourcesFilter() {
        Predicate<CharSequence> qualifierPredicate = MorePredicates.compose(this.includedFiles, this.excludedFiles, REGEX_CONTAINS_BUILDER_FUNCTION);
        Predicate qualifierResourcePredicate = Predicates.compose(qualifierPredicate, RESOURCE_QUALIFIER_FUNCTION);
        Predicate<CharSequence> contentTypePredicate = MorePredicates.compose(this.includedContentTypes, this.excludedContentTypes, REGEX_CONTAINS_BUILDER_FUNCTION);
        Predicate contentTypeResourcePredicate = Predicates.compose(contentTypePredicate, CONTENT_TYPE_FUNCTION);
        return Predicates.and((Predicate)qualifierResourcePredicate, (Predicate)contentTypeResourcePredicate);
    }

    private URL resolveWebRoot() throws MalformedURLException {
        File result = new File(this.webRoot);
        if (!result.exists()) {
            result = new File(".", this.webRoot);
        }
        if (!result.exists()) {
            return null;
        }
        return result.toURI().toURL();
    }

    private void scanDynamicResources(Collection<VFSRoot> cpFiles, ResourceFactory resourceFactory) throws Exception {
        DynamicResourcesScanner scanner = new DynamicResourcesScanner(cpFiles, resourceFactory);
        scanner.scan();
        this.foundResources.addAll(scanner.getResources());
    }

    private void scanStaticResources(Collection<VirtualFile> resourceRoots) throws Exception {
        StaticResourcesScanner scanner = new StaticResourcesScanner(resourceRoots);
        scanner.scan();
        this.foundResources.addAll(scanner.getResources());
    }

    private void scanResourceOrdering(Collection<VFSRoot> cpFiles) throws Exception {
        ResourceOrderingScanner scanner = new ResourceOrderingScanner(cpFiles, log);
        scanner.scan();
        this.resourceOrdering = scanner.getCompleteOrdering();
        this.resourcesWithKnownOrder = Sets.newLinkedHashSet(scanner.getResources());
    }

    private Collection<VFSRoot> fromUrls(Iterable<URL> urls) throws URISyntaxException, IOException {
        ArrayList result = Lists.newArrayList();
        for (URL url : urls) {
            if (url == null) continue;
            VFSRoot vfsRoot = VFS.getRoot(url);
            vfsRoot.initialize();
            result.add(vfsRoot);
        }
        return result;
    }

    private Collection<VFSRoot> getClasspathVfs(URL[] urls) throws URISyntaxException, IOException {
        return this.fromUrls(Arrays.asList(urls));
    }

    private Collection<VFSRoot> getWebrootVfs() throws URISyntaxException, IOException {
        return this.fromUrls(Collections.singletonList(this.resolveWebRoot()));
    }

    protected URL[] getProjectClassPath() {
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(this.classpathDir.getAbsolutePath());
        URL[] urlClasspath = Collections2.filter((Collection)Collections2.transform(classpath, this.filePathToURL), (Predicate)Predicates.notNull()).toArray(EMPTY_URL_ARRAY);
        return urlClasspath;
    }

    protected ClassLoader createProjectClassLoader(URL[] cp) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        classLoader = new URLClassLoader(cp, classLoader);
        return classLoader;
    }

    private void initializeServiceTracker() {
        ServicesFactoryImpl servicesFactory = new ServicesFactoryImpl();
        ServiceTracker.setFactory(servicesFactory);
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(new ServiceFactoryModule());
        servicesFactory.init(modules);
    }

    private void reorderFoundResources(Collection<VFSRoot> cpResources, DynamicResourceHandler dynamicResourceHandler, ResourceFactory resourceFactory) throws Exception {
        FacesImpl faces = new FacesImpl(null, new FileNameMapperImpl(this.fileNameMappings), dynamicResourceHandler);
        faces.start();
        this.initializeServiceTracker();
        this.foundResources = new ResourceLibraryExpander().expandResourceLibraries(this.foundResources);
        faces.startRequest();
        this.scanResourceOrdering(cpResources);
        faces.stopRequest();
        faces.stop();
        this.foundResources = this.resourceOrdering.sortedCopy(this.foundResources);
        this.foundResources.remove(ResourceConstants.JSF_UNCOMPRESSED);
        this.resourcesWithKnownOrder.add(ResourceConstants.JSF_UNCOMPRESSED);
        log.debug("resourcesWithKnownOrder: " + this.resourcesWithKnownOrder);
    }

    public void execute() {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        Faces faces = null;
        ExecutorService executorService = null;
        Collection<VFSRoot> webResources = null;
        Collection<VFSRoot> cpResources = null;
        try {
            URL[] projectCP = this.getProjectClassPath();
            ClassLoader projectCL = this.createProjectClassLoader(projectCP);
            Thread.currentThread().setContextClassLoader(projectCL);
            webResources = this.getWebrootVfs();
            cpResources = this.getClasspathVfs(projectCP);
            Collection<VirtualFile> resourceRoots = ResourceUtil.getResourceRoots(cpResources, webResources);
            log.debug("resourceRoots: " + resourceRoots);
            this.scanStaticResources(resourceRoots);
            StaticResourceHandler staticResourceHandler = new StaticResourceHandler(resourceRoots);
            ResourceFactoryImpl resourceFactory = new ResourceFactoryImpl(staticResourceHandler);
            this.scanDynamicResources(cpResources, resourceFactory);
            DynamicResourceHandler dynamicResourceHandler = new DynamicResourceHandler(staticResourceHandler, resourceFactory);
            log.debug("foundResources: " + this.foundResources);
            if (this.pack != null) {
                this.reorderFoundResources(cpResources, dynamicResourceHandler, resourceFactory);
            }
            faces = new FacesImpl(null, new FileNameMapperImpl(this.fileNameMappings), dynamicResourceHandler);
            faces.start();
            ResourceWriterImpl resourceWriter = new ResourceWriterImpl(new File(this.resourcesOutputDir), this.getDefaultResourceProcessors(), log, this.resourcesWithKnownOrder);
            ResourceTaskFactoryImpl taskFactory = new ResourceTaskFactoryImpl(faces, this.pack);
            taskFactory.setResourceWriter(resourceWriter);
            executorService = this.createExecutorService();
            CountingExecutorCompletionService<Object> completionService = new CountingExecutorCompletionService<Object>(executorService);
            taskFactory.setCompletionService(completionService);
            taskFactory.setSkins((String[])Iterables.toArray((Iterable)Constants.COMMA_SPLITTER.split((CharSequence)this.skins), String.class));
            taskFactory.setLog(log);
            taskFactory.setFilter(this.createResourcesFilter());
            taskFactory.submit(this.foundResources);
            log.debug(((Object)completionService).toString());
            Future future = null;
            while ((future = completionService.take()) != null) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    log.error(e);
                }
            }
            log.debug(((Object)completionService).toString());
            resourceWriter.writeProcessedResourceMappings(new File(this.staticResourceMappingFile), this.staticResourcePrefix);
            resourceWriter.close();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            if (cpResources != null) {
                for (VFSRoot vfsRoot : cpResources) {
                    try {
                        vfsRoot.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (webResources != null) {
                for (VFSRoot vfsRoot : webResources) {
                    try {
                        vfsRoot.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (executorService != null) {
                executorService.shutdown();
            }
            if (faces != null) {
                try {
                    faces.stop();
                }
                catch (Exception e) {
                    log.warn("Failed to tear Faces down", e);
                }
            }
            Thread.currentThread().setContextClassLoader(contextCL);
        }
    }

    public boolean isHelp() {
        return this.help;
    }
}

