package org.richfaces.demo.capitals;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.faces.FacesException;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.xml.sax.SAXException;

public class CapitalsBean {
	private ArrayList capitals = new ArrayList();
    private String capital = ""; 
	
	public List autocomplete(Object suggest) {
        String pref = (String)suggest;
        ArrayList result = new ArrayList();

        Iterator iterator = getCapitals().iterator();
        while (iterator.hasNext()) {
            Capital elem = ((Capital) iterator.next());
            if ((elem.getName() != null && elem.getName().toLowerCase().indexOf(pref.toLowerCase()) == 0) || "".equals(pref))
            {
                result.add(elem);
            }
        }
        return result;
    }
    
	public CapitalsBean() {
		URL rulesUrl = getClass().getResource("capitals-rules.xml");
		Digester digester =	DigesterLoader.createDigester(rulesUrl);
		digester.push(this);
		try {
			digester.parse(getClass().getResourceAsStream("capitals.xml"));
		} catch (IOException e) {
			throw new FacesException(e);
		} catch (SAXException e) {
			throw new FacesException(e);
		}

	}
	
	public String addCapital(Capital capital) {
		capitals.add(capital);
		return null;
	}
	
	public ArrayList getCapitals() {
		return capitals;
	}

	public String getCapital() {
		return capital;
	}

	public void setCapital(String capital) {
		this.capital = capital;
	}
	
}
