package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import org.richfaces.component.UIDragSupport;

public class HtmlDragSupport extends UIDragSupport{

public static final  String COMPONENT_FAMILY = "org.richfaces.DragSupport";

public static final  String COMPONENT_TYPE = "org.richfaces.DragSupport";

/*
* ajaxSingle
*/
private  boolean _ajaxSingle = false;

private  boolean _ajaxSingleSet = false;

/*
* bypassUpdates
*/
private  boolean _bypassUpdates = false;

private  boolean _bypassUpdatesSet = false;

/*
* data
*/
private  Object _data = null;

/*
* Disable default action for target event (append "return false;" to JavaScript)
*/
private  String _disableDefault = null;

/*
* Id of a component that is used as drag pointer during the drag operation
*/
private  String _dragIndicator = null;

/*
* MethodBinding representing an action listener method that will be notified after drag operation
*/
private  MethodBinding _dragListener = null;

/*
* A drag zone type that is used for zone definition, which elements can be accepted by a drop zone
*/
private  String _dragType = null;

/*
* Data to be sent to a drop zone after a drop event
*/
private  Object _dragValue = null;

/*
* Name of requests queue to avoid send next request before complete other from same event. Can be used to reduce number of requests of frequently events (key press, mouse move etc.)
*/
private  String _eventsQueue = null;

/*
* id of element to set focus after request completed on client side
*/
private  String _focus = null;

/*
* List of comma separated cursors that indicates then you can grab and drag an object
*/
private  String _grabCursors = null;

/*
* list of comma separated cursors that indicates then the you has grabbed something
*/
private  String _grabbingCursors = null;

/*
* Attribute allows to ignore an Ajax Response produced by a request if the newest 'similar' request is
in a queue already. ignoreDupResponses="true" does not cancel the request while it is processed on the server,
but just allows to avoid unnecessary updates on the client side if the response isn't actual now
*/
private  boolean _ignoreDupResponses = false;

private  boolean _ignoreDupResponsesSet = false;

/*
* If "true", then of all AJAX-rendered on the page components only those will be updated, 
		which ID's are passed to the "reRender" attribute of the describable component. 
		"false"-the default value-means that all components with ajaxRendered="true" will be updated.
*/
private  boolean _limitToList = false;

private  boolean _limitToListSet = false;

/*
* The client side script method to be called before DOM is updated
*/
private  String _onbeforedomupdate = null;

/*
* The client side script method to be called after the request is completed
*/
private  String _oncomplete = null;

/*
* A JavaScript event handler called after a drag operation
*/
private  String _ondragend = null;

/*
* A JavaScript event handler called before drag operation
*/
private  String _ondragstart = null;

/*
* A JavaScript event handler called after a out operation
*/
private  String _ondropout = null;

/*
* A JavaScript event handler called after a drop operation
*/
private  String _ondropover = null;

/*
* process
*/
private  Object _process = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, rendered in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _reRender = null;

/*
* Attribute defines the time (in ms.) that the request will be wait in the queue before it is ready to send.
When the delay time is over, the request will be sent to the server or removed if the newest 'similar' request is in a queue already
*/
private  int _requestDelay = Integer.MIN_VALUE;

private  boolean _requestDelaySet = false;

/*
* If there are any component requests with identical IDs then these requests will be grouped.
*/
private  String _similarityGroupingId = null;

/*
* ID (in format of call UIComponent.findComponent()) of Request status component
*/
private  String _status = null;

/*
* Response waiting time on a particular request. If a response is not received during this time, the request is aborted
*/
private  int _timeout = Integer.MIN_VALUE;

private  boolean _timeoutSet = false;


public HtmlDragSupport(){
setRendererType("org.richfaces.DragSupportRenderer");
}

public boolean isAjaxSingle(){
	if (this._ajaxSingleSet) {
	    return (this._ajaxSingle);
	}
	ValueExpression ve = getValueExpression("ajaxSingle");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ajaxSingle);
	    }
	    
	    return value;
	} else {
	    return (this._ajaxSingle);
	}

}

public void setAjaxSingle(boolean _ajaxSingle){
this._ajaxSingle = _ajaxSingle;
this._ajaxSingleSet = true;
}

public boolean isBypassUpdates(){
	if (this._bypassUpdatesSet) {
	    return (this._bypassUpdates);
	}
	ValueExpression ve = getValueExpression("bypassUpdates");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._bypassUpdates);
	    }
	    
	    return value;
	} else {
	    return (this._bypassUpdates);
	}

}

public void setBypassUpdates(boolean _bypassUpdates){
this._bypassUpdates = _bypassUpdates;
this._bypassUpdatesSet = true;
}

public Object getData(){
	if (this._data != null) {
		return this._data;
	}
	ValueExpression ve = getValueExpression("data");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setData(Object _data){
this._data = _data;
}

public String getDisableDefault(){
	if (this._disableDefault != null) {
		return this._disableDefault;
	}
	ValueExpression ve = getValueExpression("disableDefault");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDisableDefault(String _disableDefault){
this._disableDefault = _disableDefault;
}

public String getDragIndicator(){
	if (this._dragIndicator != null) {
		return this._dragIndicator;
	}
	ValueExpression ve = getValueExpression("dragIndicator");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDragIndicator(String _dragIndicator){
this._dragIndicator = _dragIndicator;
}

public MethodBinding getDragListener(){
return _dragListener;
}

public void setDragListener(MethodBinding _dragListener){
this._dragListener = _dragListener;
}

public String getDragType(){
	if (this._dragType != null) {
		return this._dragType;
	}
	ValueExpression ve = getValueExpression("dragType");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDragType(String _dragType){
this._dragType = _dragType;
}

public Object getDragValue(){
	if (this._dragValue != null) {
		return this._dragValue;
	}
	ValueExpression ve = getValueExpression("dragValue");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDragValue(Object _dragValue){
this._dragValue = _dragValue;
}

public String getEventsQueue(){
	if (this._eventsQueue != null) {
		return this._eventsQueue;
	}
	ValueExpression ve = getValueExpression("eventsQueue");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setEventsQueue(String _eventsQueue){
this._eventsQueue = _eventsQueue;
}

public String getFocus(){
	if (this._focus != null) {
		return this._focus;
	}
	ValueExpression ve = getValueExpression("focus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFocus(String _focus){
this._focus = _focus;
}

public String getGrabCursors(){
	if (this._grabCursors != null) {
		return this._grabCursors;
	}
	ValueExpression ve = getValueExpression("grabCursors");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setGrabCursors(String _grabCursors){
this._grabCursors = _grabCursors;
}

public String getGrabbingCursors(){
	if (this._grabbingCursors != null) {
		return this._grabbingCursors;
	}
	ValueExpression ve = getValueExpression("grabbingCursors");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setGrabbingCursors(String _grabbingCursors){
this._grabbingCursors = _grabbingCursors;
}

public boolean isIgnoreDupResponses(){
	if (this._ignoreDupResponsesSet) {
	    return (this._ignoreDupResponses);
	}
	ValueExpression ve = getValueExpression("ignoreDupResponses");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ignoreDupResponses);
	    }
	    
	    return value;
	} else {
	    return (this._ignoreDupResponses);
	}

}

public void setIgnoreDupResponses(boolean _ignoreDupResponses){
this._ignoreDupResponses = _ignoreDupResponses;
this._ignoreDupResponsesSet = true;
}

public boolean isLimitToList(){
	if (this._limitToListSet) {
	    return (this._limitToList);
	}
	ValueExpression ve = getValueExpression("limitToList");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._limitToList);
	    }
	    
	    return value;
	} else {
	    return (this._limitToList);
	}

}

public void setLimitToList(boolean _limitToList){
this._limitToList = _limitToList;
this._limitToListSet = true;
}

public String getOnbeforedomupdate(){
	if (this._onbeforedomupdate != null) {
		return this._onbeforedomupdate;
	}
	ValueExpression ve = getValueExpression("onbeforedomupdate");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnbeforedomupdate(String _onbeforedomupdate){
this._onbeforedomupdate = _onbeforedomupdate;
}

public String getOncomplete(){
	if (this._oncomplete != null) {
		return this._oncomplete;
	}
	ValueExpression ve = getValueExpression("oncomplete");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOncomplete(String _oncomplete){
this._oncomplete = _oncomplete;
}

public String getOndragend(){
	if (this._ondragend != null) {
		return this._ondragend;
	}
	ValueExpression ve = getValueExpression("ondragend");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndragend(String _ondragend){
this._ondragend = _ondragend;
}

public String getOndragstart(){
	if (this._ondragstart != null) {
		return this._ondragstart;
	}
	ValueExpression ve = getValueExpression("ondragstart");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndragstart(String _ondragstart){
this._ondragstart = _ondragstart;
}

public String getOndropout(){
	if (this._ondropout != null) {
		return this._ondropout;
	}
	ValueExpression ve = getValueExpression("ondropout");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndropout(String _ondropout){
this._ondropout = _ondropout;
}

public String getOndropover(){
	if (this._ondropover != null) {
		return this._ondropover;
	}
	ValueExpression ve = getValueExpression("ondropover");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOndropover(String _ondropover){
this._ondropover = _ondropover;
}

public Object getProcess(){
	if (this._process != null) {
		return this._process;
	}
	ValueExpression ve = getValueExpression("process");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setProcess(Object _process){
this._process = _process;
}

public Object getReRender(){
	if (this._reRender != null) {
		return this._reRender;
	}
	ValueExpression ve = getValueExpression("reRender");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setReRender(Object _reRender){
this._reRender = _reRender;
}

public int getRequestDelay(){
	if (this._requestDelaySet) {
	    return (this._requestDelay);
	}
	ValueExpression ve = getValueExpression("requestDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._requestDelay);
	    }
	    
	    return value;
	} else {
	    return (this._requestDelay);
	}

}

public void setRequestDelay(int _requestDelay){
this._requestDelay = _requestDelay;
this._requestDelaySet = true;
}

public String getSimilarityGroupingId(){
	if (this._similarityGroupingId != null) {
		return this._similarityGroupingId;
	}
	ValueExpression ve = getValueExpression("similarityGroupingId");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSimilarityGroupingId(String _similarityGroupingId){
this._similarityGroupingId = _similarityGroupingId;
}

public String getStatus(){
	if (this._status != null) {
		return this._status;
	}
	ValueExpression ve = getValueExpression("status");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStatus(String _status){
this._status = _status;
}

public int getTimeout(){
	if (this._timeoutSet) {
	    return (this._timeout);
	}
	ValueExpression ve = getValueExpression("timeout");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._timeout);
	    }
	    
	    return value;
	} else {
	    return (this._timeout);
	}

}

public void setTimeout(int _timeout){
this._timeout = _timeout;
this._timeoutSet = true;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[33];
state[0] = super.saveState(context);
state[1] = Boolean.valueOf(_ajaxSingle);
state[2] = Boolean.valueOf(_ajaxSingleSet);
state[3] = Boolean.valueOf(_bypassUpdates);
state[4] = Boolean.valueOf(_bypassUpdatesSet);
state[5] = saveAttachedState(context, _data);
state[6] = _disableDefault;
state[7] = _dragIndicator;
state[8] = saveAttachedState(context, _dragListener);
state[9] = _dragType;
state[10] = saveAttachedState(context, _dragValue);
state[11] = _eventsQueue;
state[12] = _focus;
state[13] = _grabCursors;
state[14] = _grabbingCursors;
state[15] = Boolean.valueOf(_ignoreDupResponses);
state[16] = Boolean.valueOf(_ignoreDupResponsesSet);
state[17] = Boolean.valueOf(_limitToList);
state[18] = Boolean.valueOf(_limitToListSet);
state[19] = _onbeforedomupdate;
state[20] = _oncomplete;
state[21] = _ondragend;
state[22] = _ondragstart;
state[23] = _ondropout;
state[24] = _ondropover;
state[25] = saveAttachedState(context, _process);
state[26] = saveAttachedState(context, _reRender);
state[27] = Integer.valueOf(_requestDelay);
state[28] = Boolean.valueOf(_requestDelaySet);
state[29] = _similarityGroupingId;
state[30] = _status;
state[31] = Integer.valueOf(_timeout);
state[32] = Boolean.valueOf(_timeoutSet);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_ajaxSingle = ((Boolean)states[1]).booleanValue();
		_ajaxSingleSet = ((Boolean)states[2]).booleanValue();
		_bypassUpdates = ((Boolean)states[3]).booleanValue();
		_bypassUpdatesSet = ((Boolean)states[4]).booleanValue();
		_data = (Object)restoreAttachedState(context, states[5]);
		_disableDefault = (String)states[6];;
		_dragIndicator = (String)states[7];;
		_dragListener = (MethodBinding)restoreAttachedState(context, states[8]);
		_dragType = (String)states[9];;
		_dragValue = (Object)restoreAttachedState(context, states[10]);
		_eventsQueue = (String)states[11];;
		_focus = (String)states[12];;
		_grabCursors = (String)states[13];;
		_grabbingCursors = (String)states[14];;
		_ignoreDupResponses = ((Boolean)states[15]).booleanValue();
		_ignoreDupResponsesSet = ((Boolean)states[16]).booleanValue();
		_limitToList = ((Boolean)states[17]).booleanValue();
		_limitToListSet = ((Boolean)states[18]).booleanValue();
		_onbeforedomupdate = (String)states[19];;
		_oncomplete = (String)states[20];;
		_ondragend = (String)states[21];;
		_ondragstart = (String)states[22];;
		_ondropout = (String)states[23];;
		_ondropover = (String)states[24];;
		_process = (Object)restoreAttachedState(context, states[25]);
		_reRender = (Object)restoreAttachedState(context, states[26]);
		_requestDelay = ((Integer)states[27]).intValue();
		_requestDelaySet = ((Boolean)states[28]).booleanValue();
		_similarityGroupingId = (String)states[29];;
		_status = (String)states[30];;
		_timeout = ((Integer)states[31]).intValue();
		_timeoutSet = ((Boolean)states[32]).booleanValue();
	
}

}
